/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.adapters.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.WithTag;
import net.serenitybdd.annotations.WithTags;
import net.thucydides.model.adapters.JUnitStrategy;
import net.thucydides.model.domain.TestTag;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.opentest4j.TestAbortedException;

class JUnit5Strategy
implements JUnitStrategy {
    JUnit5Strategy() {
    }

    public boolean isTestClass(Class<?> testClass) {
        if (this.hasTestMethods(testClass)) {
            return true;
        }
        if (!this.hasNestedTestClasses(testClass)) {
            return false;
        }
        return Arrays.stream(testClass.getDeclaredClasses()).anyMatch(this::isTestClass);
    }

    private boolean hasNestedTestClasses(Class<?> testClass) {
        return Arrays.stream(testClass.getDeclaredClasses()).anyMatch(this::isNestedTestClass);
    }

    private boolean hasTestMethods(Class<?> testClass) {
        return Arrays.stream(testClass.getDeclaredMethods()).anyMatch(this::isTestMethod);
    }

    private boolean isNestedTestClass(Class testClass) {
        return testClass.getAnnotation(Nested.class) != null;
    }

    public boolean isTestMethod(Method method) {
        boolean testMethod = method.getAnnotation(Test.class) != null || method.getAnnotation(ParameterizedTest.class) != null;
        return testMethod;
    }

    public boolean isTestSetupMethod(Method method) {
        return method.getAnnotation(BeforeEach.class) != null || method.getAnnotation(BeforeAll.class) != null;
    }

    public boolean isSerenityTestCase(Class<?> testClass) {
        return Arrays.stream(testClass.getDeclaredMethods()).anyMatch(this::isTestMethod);
    }

    public boolean isIgnored(Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getName().contains("Disabled"));
    }

    private boolean hasSerenityAnnotation(Class<?> clazz, Set<Class<?>> checked) {
        checked.add(clazz);
        return Arrays.stream(clazz.getAnnotations()).anyMatch(a -> this.carriesSerenityExtension((Annotation)a, checked));
    }

    private boolean carriesSerenityExtension(Annotation annotation, Set<Class<?>> checked) {
        if (annotation instanceof ExtendWith) {
            return Arrays.stream(((ExtendWith)annotation).value()).anyMatch(c -> c.getSimpleName().matches("Serenity.*Extension"));
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType.getPackage().getName().startsWith("java.lang") || checked.contains(annotation.annotationType())) {
            return false;
        }
        return this.hasSerenityAnnotation(annotation.annotationType(), checked);
    }

    public boolean isAssumptionViolatedException(Throwable throwable) {
        return throwable instanceof TestAbortedException;
    }

    public boolean isATaggableClass(Class<?> testClass) {
        return false;
    }

    public Optional<String> getTitleAnnotation(Method testMethod) {
        DisplayName displayNameAnnotation = testMethod.getAnnotation(DisplayName.class);
        if (displayNameAnnotation != null) {
            return Optional.of(displayNameAnnotation.value());
        }
        return Optional.empty();
    }

    public List<TestTag> getTagsFor(Method testMethod) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        for (Annotation currentAnnotation : testMethod.getDeclaredAnnotations()) {
            if (currentAnnotation instanceof WithTag) {
                String name = ((WithTag)currentAnnotation).name();
                String type = ((WithTag)currentAnnotation).type();
                String value = ((WithTag)currentAnnotation).value();
                if (name != null) {
                    tags.add(TestTag.withName((String)name).andType(type));
                } else {
                    tags.add(TestTag.withValue((String)value));
                }
            }
            if (currentAnnotation instanceof WithTags) {
                List testTags = Arrays.stream(((WithTags)currentAnnotation).value()).map(tag -> {
                    String name = tag.name();
                    String type = tag.type();
                    String value = tag.value();
                    if (name != null) {
                        return TestTag.withName((String)name).andType(type);
                    }
                    return TestTag.withValue((String)value);
                }).collect(Collectors.toList());
                tags.addAll(testTags);
            }
            if (currentAnnotation instanceof Tag) {
                tags.add(TestTag.withValue((String)((Tag)currentAnnotation).value()));
            }
            if (!(currentAnnotation instanceof Tags)) continue;
            Tag[] allTags = ((Tags)currentAnnotation).value();
            Arrays.stream(allTags).forEach(tag -> tags.add(TestTag.withValue((String)tag.value())));
        }
        return tags;
    }
}

