/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.core.internal.gherkin.ast.Examples;
import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import java.util.Optional;
import net.thucydides.core.requirements.model.cucumber.ExampleTableInMarkdown;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;
import net.thucydides.core.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.core.requirements.model.cucumber.ScenarioReport;

public class IdentifiedExampleTable
extends NamedExampleTable {
    private Feature feature;
    private String scenarioReport;
    private ScenarioDefinition scenarioDefinition;
    private String exampleTableName;
    private ExampleTableInMarkdown exampleTableInMarkdown;

    protected IdentifiedExampleTable(Feature feature, ScenarioDefinition scenarioDefinition, String exampleTableName) {
        this.feature = feature;
        this.scenarioReport = ScenarioReport.forScenario(scenarioDefinition.getName()).inFeature(feature);
        this.scenarioDefinition = scenarioDefinition;
        this.exampleTableName = exampleTableName;
        this.exampleTableInMarkdown = new ExampleTableInMarkdown(feature, this.scenarioReport, scenarioDefinition);
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (!(this.scenarioDefinition instanceof ScenarioOutline)) {
            return Optional.empty();
        }
        ScenarioOutline scenarioOutline = (ScenarioOutline)this.scenarioDefinition;
        int exampleRow = 0;
        for (Examples example : scenarioOutline.getExamples()) {
            if (example.getName().equalsIgnoreCase(this.exampleTableName.trim())) {
                return Optional.of(this.exampleTableInMarkdown.renderedFormOf(example, exampleRow, withDisplayOption));
            }
            ++exampleRow;
        }
        return Optional.empty();
    }
}

