/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.core.internal.gherkin.ast.Feature;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;

public class ReferencedExampleTable {
    private Feature feature;

    public ReferencedExampleTable(Feature feature) {
        this.feature = feature;
    }

    public static ReferencedExampleTable in(Feature feature) {
        return new ReferencedExampleTable(feature);
    }

    public NamedExampleTable withName(String exampleTableName) {
        return this.feature.getChildren().stream().filter(scenarioDefinition -> this.featureContainsExampleTableWithName(exampleTableName)).map(scenarioDefinition -> NamedExampleTable.forScenarioDefinition(this.feature, scenarioDefinition, exampleTableName)).findFirst().orElse(NamedExampleTable.withNoMatchingScenario());
    }

    private boolean featureContainsExampleTableWithName(String exampleTableName) {
        return this.feature.getChildren().stream().anyMatch(scenarioDefinition -> this.scenarioContainsExampleTableWithName((ScenarioDefinition)scenarioDefinition, exampleTableName));
    }

    private boolean scenarioContainsExampleTableWithName(ScenarioDefinition scenarioDefinition, String exampleTableName) {
        if (!(scenarioDefinition instanceof ScenarioOutline)) {
            return false;
        }
        return ((ScenarioOutline)scenarioDefinition).getExamples().stream().anyMatch(examplesTable -> examplesTable.getName().equalsIgnoreCase(exampleTableName.trim()));
    }
}

