/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;

public class Stories {
    public static Story findStoryFrom(Class<?> testClass) {
        if (Stories.storyIsDefinedIn(testClass)) {
            return Stories.storyFrom(testClass);
        }
        return Story.from(testClass);
    }

    public static String reportFor(Story story, ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getNormalizedTestNameFor(story);
    }

    private static Story storyFrom(Class<?> testClass) {
        Class<?> testedStoryClass = Story.testedInTestCase(testClass);
        if (testedStoryClass != null) {
            return Story.from(testedStoryClass);
        }
        return null;
    }

    private static boolean storyIsDefinedIn(Class<?> testClass) {
        return Stories.storyFrom(testClass) != null;
    }
}

