/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.failures;

import com.google.common.base.Splitter;
import io.cucumber.java.PendingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.SkipStepException;
import net.serenitybdd.core.exceptions.CausesAssertionFailure;
import net.serenitybdd.core.exceptions.CausesCompromisedTestFailure;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailureAnalysisConfiguration {
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(FailureAnalysisConfiguration.class);
    private final List<Class<?>> DEFAULT_FAILURE_TYPES = new ArrayList();
    private final List<Class<?>> DEFAULT_COMPROMISED_TYPES;
    private final List<Class<?>> DEFAULT_PENDING_TYPES;
    private final List<Class<?>> DEFAULT_SKIPPED_TYPES;
    private final List<Class<?>> DEFAULT_ERROR_TYPES;

    public FailureAnalysisConfiguration(EnvironmentVariables environmentVariables) {
        this.DEFAULT_FAILURE_TYPES.addAll(Arrays.asList(AssertionError.class, CausesAssertionFailure.class));
        this.DEFAULT_COMPROMISED_TYPES = new ArrayList();
        this.DEFAULT_COMPROMISED_TYPES.addAll(Arrays.asList(CausesCompromisedTestFailure.class));
        this.DEFAULT_PENDING_TYPES = new ArrayList();
        this.DEFAULT_PENDING_TYPES.addAll(Arrays.asList(PendingStepException.class, PendingException.class));
        this.DEFAULT_SKIPPED_TYPES = new ArrayList();
        this.DEFAULT_SKIPPED_TYPES.addAll(Arrays.asList(SkipStepException.class));
        this.DEFAULT_ERROR_TYPES = new ArrayList();
        this.DEFAULT_ERROR_TYPES.addAll(Arrays.asList(Error.class));
        this.environmentVariables = environmentVariables;
    }

    public List<Class<?>> failureTypes() {
        ArrayList failureTypes = new ArrayList(this.DEFAULT_FAILURE_TYPES);
        failureTypes.addAll(this.failureTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.skippedTypesDefinedIn(this.environmentVariables));
        failureTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        return failureTypes;
    }

    public List<Class<?>> compromisedTypes() {
        ArrayList compromisedTypes = new ArrayList(this.DEFAULT_COMPROMISED_TYPES);
        compromisedTypes.addAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.skippedTypesDefinedIn(this.environmentVariables));
        compromisedTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return compromisedTypes;
    }

    public List<Class<?>> pendingTypes() {
        ArrayList pendingTypes = new ArrayList(this.DEFAULT_PENDING_TYPES);
        pendingTypes.addAll(this.pendingTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.skippedTypesDefinedIn(this.environmentVariables));
        pendingTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return pendingTypes;
    }

    public List<Class<?>> skippedTypes() {
        ArrayList skippedTypes = new ArrayList(this.DEFAULT_SKIPPED_TYPES);
        skippedTypes.addAll(this.skippedTypesDefinedIn(this.environmentVariables));
        skippedTypes.removeAll(this.errorTypesDefinedIn(this.environmentVariables));
        skippedTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        skippedTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        skippedTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return skippedTypes;
    }

    public List<Class<?>> errorTypes() {
        ArrayList errorTypes = new ArrayList(this.DEFAULT_ERROR_TYPES);
        errorTypes.addAll(this.errorTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.pendingTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.skippedTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.compromisedTypesDefinedIn(this.environmentVariables));
        errorTypes.removeAll(this.failureTypesDefinedIn(this.environmentVariables));
        return errorTypes;
    }

    private List<Class<?>> errorTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_ERROR_ON, environmentVariables);
    }

    private List<Class<?>> failureTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_FAIL_ON, environmentVariables);
    }

    private List<Class<?>> pendingTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_PENDING_ON, environmentVariables);
    }

    private List<Class<?>> compromisedTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_COMPROMISED_ON, environmentVariables);
    }

    private List<Class<?>> skippedTypesDefinedIn(EnvironmentVariables environmentVariables) {
        return this.typesDefinedIn(ThucydidesSystemProperty.SERENITY_SKIPPED_ON, environmentVariables);
    }

    private List<Class<?>> typesDefinedIn(ThucydidesSystemProperty typeListProperty, EnvironmentVariables environmentVariables) {
        ArrayList definedTypes = new ArrayList();
        List classNames = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)typeListProperty.from(environmentVariables, ""));
        for (String className : classNames) {
            try {
                definedTypes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Could not find error class: " + className + "(" + e.getMessage() + ")", (Throwable)e);
            }
        }
        return definedTypes;
    }
}

