/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.serenitybdd.core.history.PreviousTestOutcome;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonPreviousOutcomeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonPreviousOutcomeConverter.class);
    private final EnvironmentVariables environmentVariables;
    Gson gson;
    private final String encoding;

    protected Gson getGson() {
        return this.gson;
    }

    @Inject
    public GsonPreviousOutcomeConverter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.encoding = ThucydidesSystemProperty.THUCYDIDES_REPORT_ENCODING.from(environmentVariables, StandardCharsets.UTF_8.name());
        GsonBuilder gsonBuilder = new GsonBuilder();
        this.gson = this.usePrettyPrinting() ? gsonBuilder.setPrettyPrinting().create() : gsonBuilder.create();
    }

    public Optional<PreviousTestOutcome> fromJson(InputStream inputStream) throws IOException {
        return this.fromJson(new InputStreamReader(inputStream, this.encoding));
    }

    public Optional<PreviousTestOutcome> fromJson(Reader jsonReader) {
        PreviousTestOutcome testOutcome = (PreviousTestOutcome)this.gson.fromJson(jsonReader, PreviousTestOutcome.class);
        return this.isValid(testOutcome) ? Optional.of(testOutcome) : Optional.empty();
    }

    private boolean isValid(PreviousTestOutcome testOutcome) {
        return !StringUtils.isEmpty((CharSequence)testOutcome.getId());
    }

    public void toJson(PreviousTestOutcome testOutcome, OutputStream outputStream) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter(outputStream, this.encoding);){
            this.gson.toJson((Object)testOutcome, (Appendable)out);
        }
    }

    private boolean usePrettyPrinting() {
        return Boolean.parseBoolean(ThucydidesSystemProperty.JSON_PRETTY_PRINTING.from(this.environmentVariables, "false"));
    }
}

