/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class CompoundDuration {
    private static final String MILLISECONDS_FORMAT = "SSS'ms'";
    private static final String SECONDS_FORMAT = "s's' SSS'ms'";
    private static final String MINUTES_FORMAT = "m'm' s's'";
    private static final String HOURS_FORMAT = "H'h' m'm' s's'";
    private static final String DAYS_FORMAT = "d'd' H'h' m'm' s's'";
    private static final Map<Long, String> FORMATS_PER_DURATION_THRESHOLD = new TreeMap<Long, String>();

    public static String of(long durationInMilliseconds) {
        String format = FORMATS_PER_DURATION_THRESHOLD.entrySet().stream().filter(entry -> durationInMilliseconds < (Long)entry.getKey()).map(entry -> (String)entry.getValue()).findFirst().orElse(DAYS_FORMAT);
        long roundedDuration = CompoundDuration.roundMillisecondsUpForLongerDurations(durationInMilliseconds);
        return CompoundDuration.trimZeroValuesFrom(DurationFormatUtils.formatDuration((long)roundedDuration, (String)format));
    }

    private static long roundMillisecondsUpForLongerDurations(long durationInMilliseconds) {
        if (durationInMilliseconds < 60000L) {
            return durationInMilliseconds;
        }
        return BigDecimal.valueOf(durationInMilliseconds).divide(BigDecimal.valueOf(1000L), RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(1000L)).longValue();
    }

    private static String trimZeroValuesFrom(String formatDuration) {
        return formatDuration.replaceAll(" 000ms$", "").replaceAll(" 0s$", "").replaceAll(" 0m$", "").replaceAll(" 0h$", "").replaceAll(" 0m 0s$", "").replaceAll(" 0h 0m 0s$", "");
    }

    static {
        FORMATS_PER_DURATION_THRESHOLD.put(1000L, MILLISECONDS_FORMAT);
        FORMATS_PER_DURATION_THRESHOLD.put(60000L, SECONDS_FORMAT);
        FORMATS_PER_DURATION_THRESHOLD.put(3600000L, MINUTES_FORMAT);
        FORMATS_PER_DURATION_THRESHOLD.put(86400000L, HOURS_FORMAT);
    }
}

