/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.util;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CopyDirectory
extends SimpleFileVisitor<Path> {
    private Path source;
    private Path target;

    public CopyDirectory(Path source, Path target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
        if (!Files.exists(this.target.resolve(this.source.relativize(file)), new LinkOption[0])) {
            Files.copy(file, this.target.resolve(this.source.relativize(file)), new CopyOption[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attributes) throws IOException {
        block2: {
            Path targetDirectory = this.target.resolve(this.source.relativize(directory));
            try {
                Files.copy(directory, targetDirectory, new CopyOption[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetDirectory, new LinkOption[0])) break block2;
                throw e;
            }
        }
        return FileVisitResult.CONTINUE;
    }
}

