/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.messages.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.requirements.model.cucumber.ExampleRowResultIcon;
import net.thucydides.core.requirements.model.cucumber.RowResultIcon;
import org.apache.commons.lang3.StringUtils;

public class RenderedExampleTable {
    public static String nameFor(Messages.GherkinDocument.Feature.Scenario.Examples exampleTable) {
        return RenderedExampleTable.emptyStringOrValueOf(exampleTable.getName());
    }

    public static String descriptionFor(Messages.GherkinDocument.Feature.Scenario.Examples exampleTable) {
        return RenderedExampleTable.emptyStringOrValueOf(exampleTable.getDescription());
    }

    private static String emptyStringOrValueOf(String description) {
        if (StringUtils.isEmpty((CharSequence)description)) {
            return "";
        }
        return description + System.lineSeparator();
    }

    public static String renderedTable(Messages.GherkinDocument.Feature.Scenario.Examples exampleTable, ExampleRowResultIcon exampleRowIcon) {
        Map<Integer, Integer> maxColumnWidths = RenderedExampleTable.maxColumnWidthForColumnsIn(exampleTable);
        String headings = RenderedExampleTable.cellRow(exampleTable.getTableHeader().getCellsList(), maxColumnWidths, exampleTable.getLocation().getLine(), exampleRowIcon.noIcon()) + RenderedExampleTable.headerSeparator(maxColumnWidths);
        String body = exampleTable.getTableBodyList().stream().map(row -> RenderedExampleTable.cellRow(row.getCellsList(), maxColumnWidths, row.getLocation().getLine(), exampleRowIcon)).collect(Collectors.joining());
        return headings + body;
    }

    private static String headerSeparator(Map<Integer, Integer> maxColumnWidths) {
        String headerSeparator = "|";
        for (int column = 0; column < maxColumnWidths.size(); ++column) {
            headerSeparator = headerSeparator + StringUtils.repeat((String)"-", (int)(maxColumnWidths.get(column) + 2)) + "|";
        }
        return headerSeparator + "---|" + System.lineSeparator();
    }

    public static String cellRow(List<Messages.GherkinDocument.Feature.TableRow.TableCell> cells, Map<Integer, Integer> maxColumnWidths, int lineNumber, RowResultIcon exampleRowResultIcons) {
        StringBuilder headerRow = new StringBuilder("|");
        for (int column = 0; column < cells.size(); ++column) {
            String columnHeading = cells.get(column).getValue();
            int columnWidth = maxColumnWidths.get(column) + 1;
            headerRow.append(StringUtils.rightPad((String)(" " + columnHeading), (int)columnWidth)).append(" |");
        }
        headerRow.append(exampleRowResultIcons.resultToken(lineNumber) + "|");
        return headerRow.toString() + System.lineSeparator();
    }

    private static Map<Integer, Integer> maxColumnWidthForColumnsIn(Messages.GherkinDocument.Feature.Scenario.Examples exampleTable) {
        HashMap<Integer, Integer> maxColumnWidth = new HashMap<Integer, Integer>();
        int columnCount = exampleTable.getTableHeader().getCellsList().size();
        for (int column = 0; column < columnCount; ++column) {
            maxColumnWidth.put(column, RenderedExampleTable.maxColumnWidthFor(exampleTable, column));
        }
        return maxColumnWidth;
    }

    private static Integer maxColumnWidthFor(Messages.GherkinDocument.Feature.Scenario.Examples exampleTable, int column) {
        int headerWidth = ((Messages.GherkinDocument.Feature.TableRow.TableCell)exampleTable.getTableHeader().getCellsList().get(column)).getValue().length();
        int maxCellWidth = exampleTable.getTableBodyList().stream().mapToInt(row -> ((Messages.GherkinDocument.Feature.TableRow.TableCell)row.getCellsList().get(column)).getValue().length()).max().orElse(0);
        return Math.max(headerWidth, maxCellWidth);
    }
}

