/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import io.cucumber.messages.Messages;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.requirements.model.cucumber.ExampleRowResultIcon;

public class RenderCucumber {
    public static String step(Messages.GherkinDocument.Feature.Step step) {
        return step.getKeyword() + RenderCucumber.withEscapedParameterFields(step.getText()) + "  " + RenderCucumber.renderedArgument(step);
    }

    private static String renderedArgument(Messages.GherkinDocument.Feature.Step step) {
        if (step.getArgumentCase().equals((Object)Messages.GherkinDocument.Feature.Step.ArgumentCase.DATA_TABLE)) {
            return RenderCucumber.renderedDataTable(step.getDataTable());
        }
        if (step.getArgumentCase().equals((Object)Messages.GherkinDocument.Feature.Step.ArgumentCase.DOC_STRING)) {
            return step.getDocString().getContent();
        }
        return "";
    }

    public static List<String> examples(List<Messages.GherkinDocument.Feature.Scenario.Examples> examples, String featureName, String scenarioName) {
        ArrayList<String> renderedExamples = new ArrayList<String>();
        for (Messages.GherkinDocument.Feature.Scenario.Examples exampleTable : examples) {
            renderedExamples.add(RenderCucumber.renderedExamples(exampleTable, featureName, scenarioName));
        }
        return renderedExamples;
    }

    private static String renderedExamples(Messages.GherkinDocument.Feature.Scenario.Examples examples, String featureName, String scenarioName) {
        ExampleRowResultIcon exampleRowResultIcon = new ExampleRowResultIcon(featureName);
        StringBuffer renderedTable = new StringBuffer();
        RenderCucumber.renderExampleDescriptionOf(examples);
        renderedTable.append(RenderCucumber.renderExampleDescriptionOf(examples));
        RenderCucumber.addRow(renderedTable, examples.getTableHeader().getCellsList(), " ");
        RenderCucumber.addSeparatorCells(renderedTable, examples.getTableHeader().getCellsList().size());
        for (Messages.GherkinDocument.Feature.TableRow row : examples.getTableBodyList()) {
            RenderCucumber.addRow(renderedTable, row.getCellsList(), exampleRowResultIcon.resultToken(row.getLocation().getLine()));
        }
        return renderedTable.toString();
    }

    private static String renderExampleDescriptionOf(Messages.GherkinDocument.Feature.Scenario.Examples examples) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(examples.getKeyword()).append(": ");
        if (examples.getName() != null) {
            renderedTable.append(examples.getName());
        }
        renderedTable.append("  ").append(System.lineSeparator());
        if (examples.getDescription() != null) {
            renderedTable.append(System.lineSeparator()).append("> ").append(examples.getDescription().trim()).append(System.lineSeparator());
        }
        renderedTable.append(System.lineSeparator());
        return renderedTable.toString();
    }

    private static String renderedExamples(Messages.GherkinDocument.Feature.Scenario.Examples examples) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append(RenderCucumber.renderExampleDescriptionOf(examples));
        RenderCucumber.addRow(renderedTable, examples.getTableHeader().getCellsList(), null);
        RenderCucumber.addSeparatorCells(renderedTable, examples.getTableHeader().getCellsCount());
        for (Messages.GherkinDocument.Feature.TableRow row : examples.getTableBodyList()) {
            RenderCucumber.addRow(renderedTable, row.getCellsList(), null);
        }
        return renderedTable.toString();
    }

    private static String renderedDataTable(Messages.GherkinDocument.Feature.Step.DataTable dataTable) {
        StringBuffer renderedTable = new StringBuffer();
        renderedTable.append("  ").append(System.lineSeparator());
        int firstRow = 0;
        Messages.GherkinDocument.Feature.TableRow header = (Messages.GherkinDocument.Feature.TableRow)dataTable.getRowsList().get(0);
        if (RenderCucumber.thereAreMultipleColumnsIn(dataTable)) {
            RenderCucumber.addRow(renderedTable, header.getCellsList());
            RenderCucumber.addSeparatorCells(renderedTable, header.getCellsList().size());
            ++firstRow;
        } else {
            RenderCucumber.addSeparatorCells(renderedTable, header.getCellsList().size());
        }
        for (int row = firstRow; row < dataTable.getRowsList().size(); ++row) {
            RenderCucumber.addRow(renderedTable, ((Messages.GherkinDocument.Feature.TableRow)dataTable.getRowsList().get(row)).getCellsList());
        }
        return renderedTable.toString();
    }

    private static boolean thereAreMultipleColumnsIn(Messages.GherkinDocument.Feature.Step.DataTable dataTable) {
        return ((Messages.GherkinDocument.Feature.TableRow)dataTable.getRowsList().get(0)).getCellsList().size() > 1;
    }

    private static void addSeparatorCells(StringBuffer renderedTable, int columnCount) {
        renderedTable.append("|");
        for (int col = 0; col < columnCount; ++col) {
            renderedTable.append("-----------").append("|");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static void addRow(StringBuffer renderedTable, List<Messages.GherkinDocument.Feature.TableRow.TableCell> cells) {
        RenderCucumber.addRow(renderedTable, cells, null);
    }

    private static void addRow(StringBuffer renderedTable, List<Messages.GherkinDocument.Feature.TableRow.TableCell> cells, String statusToken) {
        renderedTable.append("|");
        for (Messages.GherkinDocument.Feature.TableRow.TableCell cell : cells) {
            renderedTable.append(RenderCucumber.withEscapedParameterFields(cell.getValue())).append(" |");
        }
        if (statusToken != null) {
            renderedTable.append(statusToken + " |");
        }
        renderedTable.append("  ").append(System.lineSeparator());
    }

    private static String withEscapedParameterFields(String text) {
        return text.replace("<", "{").replace(">", "}");
    }
}

