/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.history;

import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.serenitybdd.core.collect.NewMap;
import net.serenitybdd.core.history.ClearDirectoryContents;
import net.serenitybdd.core.history.LeaveDirectoryContents;
import net.serenitybdd.core.history.PrepareHistoryDirectory;
import net.serenitybdd.core.history.PreviousTestOutcome;
import net.serenitybdd.core.history.TestOutcomeSummaryRecorder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.json.gson.GsonPreviousOutcomeConverter;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemTestOutcomeSummaryRecorder
implements TestOutcomeSummaryRecorder {
    private final Path historyDirectory;
    private final Boolean deletePreviousHistory;
    private final AcceptanceTestLoader testOutcomeReporter = new JSONTestOutcomeReporter();
    private final GsonPreviousOutcomeConverter previousOutcomeConverter;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemTestOutcomeSummaryRecorder.class);
    private static Map<Boolean, PrepareHistoryDirectory> DELETE_STRATEGY = NewMap.of(false, new LeaveDirectoryContents(), true, new ClearDirectoryContents());

    @Inject
    public FileSystemTestOutcomeSummaryRecorder(EnvironmentVariables environmentVariables) {
        this(Paths.get(ThucydidesSystemProperty.SERENITY_HISTORY_DIRECTORY.from(environmentVariables, "history"), ""), false);
    }

    public FileSystemTestOutcomeSummaryRecorder(Path historyDirectory, Boolean deletePreviousHistory) {
        this.historyDirectory = historyDirectory;
        this.deletePreviousHistory = Optional.ofNullable(deletePreviousHistory).orElse(false);
        this.previousOutcomeConverter = new GsonPreviousOutcomeConverter((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class));
    }

    @Override
    public void recordOutcomeSummariesFrom(Path sourceDirectory) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(sourceDirectory);){
            this.usingDeleteStrategyFor(this.deletePreviousHistory).prepareHistoryDirectory(this.historyDirectory);
            for (Path path : directoryStream) {
                this.storeOutcomesFrom(this.testOutcomeReporter.loadReportFrom(path).map(Collections::singleton).orElse(Collections.emptySet()));
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Unable to store test outcome for posterity", (Throwable)ex);
        }
    }

    private void storeOutcomesFrom(Set<TestOutcome> testOutcomes) throws IOException {
        for (TestOutcome testOutcome : testOutcomes) {
            PreviousTestOutcome summary = PreviousTestOutcome.from(testOutcome);
            File summaryFile = this.summaryFileFor(testOutcome);
            Files.createDirectories(summaryFile.toPath().getParent(), new FileAttribute[0]);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(summaryFile));
            Throwable throwable = null;
            try {
                this.previousOutcomeConverter.toJson(summary, outputStream);
                ((OutputStream)outputStream).flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (outputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((OutputStream)outputStream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((OutputStream)outputStream).close();
            }
        }
    }

    @Override
    public List<PreviousTestOutcome> loadSummaries() {
        ArrayList<PreviousTestOutcome> previousTestOutcomes = new ArrayList<PreviousTestOutcome>();
        if (Files.exists(this.historyDirectory, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.historyDirectory);){
                for (Path path : directoryStream) {
                    this.previousTestOutcomesFrom(path).ifPresent(outcome -> previousTestOutcomes.add((PreviousTestOutcome)outcome));
                }
            }
            catch (IOException ex) {
                LOGGER.warn("Unable to store test outcome for posterity", (Throwable)ex);
            }
        }
        return previousTestOutcomes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<PreviousTestOutcome> previousTestOutcomesFrom(Path source) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source.toFile()));){
            Optional<PreviousTestOutcome> optional = this.previousOutcomeConverter.fromJson(inputStream);
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    private PrepareHistoryDirectory usingDeleteStrategyFor(Boolean deletePreviousHistory) {
        return DELETE_STRATEGY.get(deletePreviousHistory);
    }

    private File summaryFileFor(TestOutcome testOutcome) {
        String summaryFilename = ReportNamer.forReportType(ReportType.JSON).withPrefix("summary-").getNormalizedTestNameFor(testOutcome);
        return this.historyDirectory.resolve(summaryFilename).toFile();
    }
}

