/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.specflow;

import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.reports.adaptors.specflow.SpecflowScenario;
import org.apache.commons.lang3.StringUtils;

public class ScenarioSplitter {
    private static final String TITLE_LEAD = "***** ";
    private final List<String> outputLines;

    public static ScenarioSplitter on(List<String> outputLines) {
        return new ScenarioSplitter(outputLines);
    }

    public ScenarioSplitter(List<String> outputLines) {
        this.outputLines = new ArrayList<String>(outputLines);
    }

    public List<SpecflowScenario> split() {
        ArrayList<SpecflowScenario> scenarios = new ArrayList<SpecflowScenario>();
        String currentTitle = null;
        SpecflowScenario currentScenario = null;
        for (List<String> blockLines : this.splitScenarios(this.outputLines)) {
            String blockTitle = blockLines.get(0);
            List<String> blockSteps = this.tail(blockLines);
            if (this.sameTitle(blockTitle, currentTitle)) {
                currentScenario.convertToTable(currentTitle);
                currentScenario.addRow(blockTitle, blockSteps);
            } else {
                currentScenario = new SpecflowScenario(this.removeParametersFrom(blockTitle));
                scenarios.add(currentScenario);
                currentScenario.addSteps(blockSteps);
            }
            currentTitle = blockTitle;
        }
        return scenarios;
    }

    private boolean sameTitle(String blockTitle, String currentTitle) {
        String blockTitleWithoutParameters = this.removeParametersFrom(blockTitle);
        String currentTitleWithoutParameters = this.removeParametersFrom(currentTitle);
        return blockTitleWithoutParameters.equals(currentTitleWithoutParameters);
    }

    private String removeParametersFrom(String title) {
        if (StringUtils.isNotEmpty((CharSequence)title) && title.indexOf("(") > -1) {
            return title.substring(0, title.indexOf("("));
        }
        return title;
    }

    private List<List<String>> splitScenarios(List<String> outputLines) {
        ArrayList<List<String>> scenarios = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        for (String line : outputLines) {
            if (this.isTitle(line)) {
                if (current != null) {
                    scenarios.add((List<String>)current);
                }
                current = new ArrayList<String>();
                current.add(line);
                continue;
            }
            current.add(line);
        }
        scenarios.add(current);
        return scenarios;
    }

    private boolean isTitle(String line) {
        return line.trim().startsWith(TITLE_LEAD);
    }

    private List<String> tail(List<String> outlineLines) {
        return new ArrayList<String>(outlineLines.subList(1, outlineLines.size()));
    }
}

