/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;

public class TestTagCache {
    private static final Map<TestOutcomeTag, Boolean> MATCHING_TAGS = new ConcurrentHashMap<TestOutcomeTag, Boolean>();

    public static Optional<Boolean> hasMatchingTag(TestOutcome outcome, TestTag tag) {
        TestOutcomeTag testOutcomeTag = new TestOutcomeTag(outcome, tag);
        return Optional.ofNullable(MATCHING_TAGS.getOrDefault(testOutcomeTag, null));
    }

    public static void storeMatchingTagResult(TestOutcome outcome, TestTag tag, boolean matchFound) {
        TestOutcomeTag testOutcomeTag = new TestOutcomeTag(outcome, tag);
        MATCHING_TAGS.put(testOutcomeTag, matchFound);
    }

    public static void clear() {
        MATCHING_TAGS.clear();
    }

    private static class TestOutcomeTag {
        private final TestOutcome testOutcome;
        private final TestTag testTag;

        private TestOutcomeTag(TestOutcome testOutcome, TestTag testTag) {
            this.testOutcome = testOutcome;
            this.testTag = testTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestOutcomeTag that = (TestOutcomeTag)o;
            if (this.testOutcome != null ? !this.testOutcome.equals(that.testOutcome) : that.testOutcome != null) {
                return false;
            }
            return this.testTag != null ? this.testTag.equals(that.testTag) : that.testTag == null;
        }

        public int hashCode() {
            int result = this.testOutcome != null ? this.testOutcome.hashCode() : 0;
            result = 31 * result + (this.testTag != null ? this.testTag.hashCode() : 0);
            return result;
        }
    }
}

