/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import java.util.Optional;
import net.thucydides.core.requirements.model.cucumber.ExampleTableInMarkdown;
import net.thucydides.core.requirements.model.cucumber.NamedExampleTable;
import net.thucydides.core.requirements.model.cucumber.ScenarioDisplayOption;
import net.thucydides.core.requirements.model.cucumber.ScenarioReport;

public class IdentifiedExampleTable
extends NamedExampleTable {
    private final Feature feature;
    private final Optional<Scenario> scenarioDefinition;
    private final String exampleTableName;
    private final ExampleTableInMarkdown exampleTableInMarkdown;

    protected IdentifiedExampleTable(Feature feature, Optional<Scenario> scenarioDefinition, String exampleTableName) {
        this.feature = feature;
        String scenarioReport = null;
        if (scenarioDefinition.isPresent()) {
            scenarioReport = ScenarioReport.forScenario(scenarioDefinition.get().getName()).inFeature(feature);
        }
        this.scenarioDefinition = scenarioDefinition;
        this.exampleTableName = exampleTableName;
        this.exampleTableInMarkdown = new ExampleTableInMarkdown(feature, scenarioReport, scenarioDefinition.isPresent() ? scenarioDefinition.get().getName() : "");
    }

    @Override
    public Optional<String> asExampleTable() {
        return this.asExampleTable(ScenarioDisplayOption.WithNoTitle);
    }

    @Override
    public Optional<String> asExampleTable(ScenarioDisplayOption withDisplayOption) {
        if (this.scenarioDefinition.isPresent()) {
            if (this.scenarioDefinition.get().getExamples().isEmpty()) {
                return Optional.empty();
            }
            int exampleRow = 0;
            for (Examples example : this.scenarioDefinition.get().getExamples()) {
                if (example.getName().equalsIgnoreCase(this.exampleTableName.trim())) {
                    return Optional.of(this.exampleTableInMarkdown.renderedFormOf(example, exampleRow, withDisplayOption));
                }
                ++exampleRow;
            }
        }
        return Optional.empty();
    }
}

