/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.environment;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewMap;
import net.thucydides.core.environment.TestLocalEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesFileLocalPreferences;
import org.apache.commons.lang3.StringUtils;

public class SystemEnvironmentVariables
implements EnvironmentVariables {
    private Map<String, String> properties;
    private final Map<String, String> systemValues;
    private Config config;
    private static final ThreadLocal<EnvironmentVariables> LOADED_ENVIRONMENT_VARIABLES = ThreadLocal.withInitial(SystemEnvironmentVariables::createEnvironmentVariables);
    private Map<String, String> pristineProperties;
    private final Lock propertySetLock = new ReentrantLock();

    private SystemEnvironmentVariables(Map<String, String> properties, Map<String, String> systemValues, Config config, Map<String, String> pristineProperties) {
        this.properties = properties;
        this.systemValues = systemValues;
        this.config = config;
        this.pristineProperties = pristineProperties;
    }

    @Override
    public EnvironmentVariables copy() {
        return new SystemEnvironmentVariables(new HashMap<String, String>(this.properties), new HashMap<String, String>(this.systemValues), this.config, new HashMap<String, String>(this.pristineProperties));
    }

    public SystemEnvironmentVariables() {
        this(System.getProperties(), System.getenv());
    }

    public static EnvironmentVariables currentEnvironmentVariables() {
        if (TestLocalEnvironmentVariables.getProperties().isEmpty()) {
            return LOADED_ENVIRONMENT_VARIABLES.get();
        }
        return TestLocalEnvironmentVariables.getUpdatedEnvironmentVariables();
    }

    @Override
    public void setConfig(Config typesafeConfig) {
        this.config = typesafeConfig.resolve();
    }

    public SystemEnvironmentVariables(Properties systemProperties, Map<String, String> systemValues) {
        this.systemValues = NewMap.copyOf(systemValues);
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (String property : systemProperties.stringPropertyNames()) {
            String value = systemProperties.getProperty(property);
            propertyValues.put(property, value);
        }
        this.properties = NewMap.copyOf(propertyValues);
        this.pristineProperties = NewMap.copyOf(propertyValues);
    }

    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = this.systemValues.get(name);
        return value == null ? defaultValue : value;
    }

    private void setValue(String name, String value) {
        this.systemValues.put(name, value);
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public List<String> getKeys() {
        return this.properties.keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        for (String key : this.properties.keySet()) {
            props.setProperty(key, this.properties.get(key));
        }
        return props;
    }

    @Override
    public Properties getPropertiesWithPrefix(String prefix) {
        Properties filteredProperties = new Properties();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            filteredProperties.put(key, this.properties.get(key));
        }
        return filteredProperties;
    }

    @Override
    public boolean aValueIsDefinedFor(Enum<?> property) {
        return this.aValueIsDefinedFor(property.toString());
    }

    @Override
    public boolean aValueIsDefinedFor(String property) {
        boolean pathIsDefined = this.config != null && this.config.hasPath(property);
        return this.properties.containsKey(property);
    }

    @Override
    public boolean hasPath(String path) {
        return this.config != null && this.config.hasPath(path);
    }

    @Override
    public String injectSystemPropertiesInto(String value) {
        if (value == null) {
            return value;
        }
        if (!value.contains("${")) {
            return value;
        }
        for (String key : this.systemValues.keySet()) {
            value = value.replace("${" + key.toUpperCase() + "}", this.systemValues.get(key));
        }
        return value;
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = this.properties.get(property);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((CharSequence)this.getProperty(name))) {
            return true;
        }
        return Boolean.parseBoolean(this.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Optional<String> optionalProperty(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.propertySetLock.lock();
        HashMap<String, String> workingCopy = new HashMap<String, String>(this.properties);
        workingCopy.put(name, value);
        this.properties = NewMap.copyOf(workingCopy);
        this.propertySetLock.unlock();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.propertySetLock.lock();
        this.properties.putAll(properties);
        this.propertySetLock.unlock();
    }

    @Override
    public void clearProperty(String name) {
        this.propertySetLock.lock();
        HashMap<String, String> workingCopy = new HashMap<String, String>(this.properties);
        workingCopy.remove(name);
        this.properties = NewMap.copyOf(workingCopy);
        this.propertySetLock.unlock();
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>(this.properties);
        environmentValues.putAll(this.systemValues);
        return environmentValues;
    }

    @Override
    public Map<String, String> simpleSystemPropertiesAsMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>();
        this.properties.keySet().stream().filter(key -> !key.contains(".")).forEach(key -> environmentValues.put((String)key, this.properties.get(key)));
        return environmentValues;
    }

    @Override
    public void reset() {
        this.properties.clear();
        this.properties.putAll(this.pristineProperties);
    }

    public static EnvironmentVariables createEnvironmentVariables() {
        return SystemEnvironmentVariables.createEnvironmentVariables(new SystemEnvironmentVariables());
    }

    public static EnvironmentVariables createEnvironmentVariables(Path configurationFile) {
        return SystemEnvironmentVariables.createEnvironmentVariables(configurationFile, new SystemEnvironmentVariables());
    }

    public static EnvironmentVariables createEnvironmentVariables(Path configurationFile, EnvironmentVariables environmentVariables) {
        PropertiesFileLocalPreferences localPreferences = new PropertiesFileLocalPreferences(environmentVariables, configurationFile);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }

    private static EnvironmentVariables createEnvironmentVariables(EnvironmentVariables environmentVariables) {
        PropertiesFileLocalPreferences localPreferences = new PropertiesFileLocalPreferences(environmentVariables);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }

    @Override
    public Config getConfig(String prefix) {
        if (this.config != null && this.config.hasPath(prefix)) {
            return this.config.getConfig(prefix);
        }
        return ConfigFactory.empty();
    }
}

