/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.reports.ReporterRuntime;
import net.thucydides.core.reports.SystemReporterRuntime;
import net.thucydides.core.util.EnvironmentVariables;

public class NumberOfThreads {
    static final Double DEFAULT_BLOCKING_COEFFICIENT_FOR_IO = 0.5;
    private final EnvironmentVariables environmentVariables;
    private final double blockingCoefficientForIO;
    private final ReporterRuntime reporterRuntime;

    public static int forIOOperations() {
        return new NumberOfThreads().forIO();
    }

    protected NumberOfThreads() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables(), new SystemReporterRuntime());
    }

    protected NumberOfThreads(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new SystemReporterRuntime());
    }

    protected NumberOfThreads(EnvironmentVariables environmentVariables, ReporterRuntime reporterRuntime) {
        this.environmentVariables = environmentVariables;
        this.blockingCoefficientForIO = Double.parseDouble(ThucydidesSystemProperty.IO_BLOCKING_COEFFICIENT.from(environmentVariables, DEFAULT_BLOCKING_COEFFICIENT_FOR_IO.toString()));
        this.reporterRuntime = reporterRuntime;
    }

    public int forIO() {
        int numberOfCores = this.reporterRuntime.availableProcessors();
        int calculatedReportThreads = Math.max(1, (int)((double)numberOfCores * 1.0 / (1.0 - this.blockingCoefficientForIO)));
        return this.configuredReportThreads().orElse(calculatedReportThreads);
    }

    private Optional<Integer> configuredReportThreads() {
        int reportThreads = ThucydidesSystemProperty.REPORT_THREADS.integerFrom(this.environmentVariables);
        if (reportThreads == 0) {
            return Optional.empty();
        }
        return Optional.of(reportThreads);
    }
}

