/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.requirements.model.cucumber.FeatureFileAnaysisErrors;
import net.thucydides.core.requirements.model.cucumber.InvalidFeatureFileException;

public class FeatureFileChecker {
    CucumberParser cucumberParser = new CucumberParser();

    public void check(Stream<File> files) {
        ConcurrentHashMap pathNamesToFeatureFiles = new ConcurrentHashMap();
        List errorMessages = files.filter(File::isFile).map(featureFile -> {
            try {
                Optional<AnnotatedFeature> loadedFeature = this.cucumberParser.loadFeature((File)featureFile);
                loadedFeature.ifPresent(annotatedFeature -> FeatureFileChecker.recordFeaturePath(pathNamesToFeatureFiles, featureFile, annotatedFeature));
                return Optional.empty();
            }
            catch (Throwable invalidFeatureFile) {
                invalidFeatureFile.printStackTrace();
                return Optional.of("* Error found in feature file: " + featureFile.getAbsolutePath() + System.lineSeparator() + "    " + invalidFeatureFile + ":" + invalidFeatureFile.getMessage());
            }
        }).filter(Optional::isPresent).map(Optional::get).map(Object::toString).collect(Collectors.toList());
        List featureNameErrors = pathNamesToFeatureFiles.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.duplicateFeaturePathsError((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        errorMessages.addAll(featureNameErrors);
        if (!errorMessages.isEmpty()) {
            throw new InvalidFeatureFileException(errorMessages.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private String duplicateFeaturePathsError(String key, List<File> value) {
        String featureFilesWithDuplicates = value.stream().map(file -> "      - " + file.getPath()).collect(Collectors.joining(System.lineSeparator()));
        return String.format("* " + FeatureFileAnaysisErrors.DUPLICATE_FEATURE_NAME, key, featureFilesWithDuplicates);
    }

    private static void recordFeaturePath(ConcurrentHashMap<String, List<File>> pathNamesToFeatureFiles, File featureFile, AnnotatedFeature loadedFeature) {
        String featureName = loadedFeature.getFeature().getName();
        String parentName = new File(featureFile.getParent()).getName();
        String localFeaturePath = parentName + "/" + featureName;
        if (pathNamesToFeatureFiles.containsKey(localFeaturePath)) {
            pathNamesToFeatureFiles.get(localFeaturePath).add(featureFile);
        } else {
            ArrayList<File> featureFiles = new ArrayList<File>();
            featureFiles.add(featureFile);
            pathNamesToFeatureFiles.put(localFeaturePath, featureFiles);
        }
    }
}

