/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.batches;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.core.batches.SystemVariableBasedBatchManager;
import net.thucydides.core.util.EnvironmentVariables;

public class TestCountBasedBatchManager
extends SystemVariableBasedBatchManager {
    private Map<Integer, AtomicInteger> batchNumberTestCount = new HashMap<Integer, AtomicInteger>();
    private Map<Integer, Integer> testCaseNumberBatchNumber = new HashMap<Integer, Integer>();

    public TestCountBasedBatchManager(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
        for (int i = 0; i < this.batchCount; ++i) {
            this.batchNumberTestCount.put(i, new AtomicInteger(0));
        }
    }

    @Override
    public boolean shouldExecuteThisTest(int testCount) {
        return this.batchCount > 0 ? this.shouldExecuteThisTestInCurrentBatch(testCount) : true;
    }

    private synchronized boolean shouldExecuteThisTestInCurrentBatch(int testCount) {
        if (!this.testCaseNumberBatchNumber.containsKey(this.getCurrentTestCaseNumber())) {
            this.addTestCaseToOptimalBatch();
        }
        this.incTestMethodsSizeInBatch(testCount);
        return this.testCaseNumberBatchNumber.get(this.getCurrentTestCaseNumber()).intValue() == this.getActualBatchNumber();
    }

    private void addTestCaseToOptimalBatch() {
        this.testCaseNumberBatchNumber.put(this.getCurrentTestCaseNumber(), this.getOptimalBatchForNewTestCase());
    }

    private int getOptimalBatchForNewTestCase() {
        int batchNumber = 0;
        AtomicInteger testMethodsSize = this.batchNumberTestCount.get(batchNumber);
        for (Map.Entry<Integer, AtomicInteger> entry : this.batchNumberTestCount.entrySet()) {
            if (testMethodsSize.get() <= entry.getValue().get()) continue;
            batchNumber = entry.getKey();
            testMethodsSize = entry.getValue();
        }
        return batchNumber;
    }

    private void incTestMethodsSizeInBatch(int testCount) {
        int batchNumber = this.testCaseNumberBatchNumber.get(this.getCurrentTestCaseNumber());
        this.batchNumberTestCount.get(batchNumber).getAndAdd(testCount);
    }
}

