/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.logging;

import net.thucydides.core.model.TestResult;

public enum ConsoleEvent {
    TEST_STARTED("Test Started"),
    TEST_PASSED("Test Passed"),
    TEST_FAILED("Test Failed"),
    TEST_ERROR("Test Error"),
    TEST_COMPROMISED("Test Compromised"),
    TEST_ABORTED("Test Aborted"),
    TEST_PENDING("Test Pending"),
    TEST_SKIPPED("Test Skipped");

    private String title;

    public static ConsoleEvent forTestResult(TestResult result) {
        switch (result) {
            case SUCCESS: {
                return TEST_PASSED;
            }
            case COMPROMISED: {
                return TEST_COMPROMISED;
            }
            case ERROR: {
                return TEST_ERROR;
            }
            case FAILURE: {
                return TEST_FAILED;
            }
            case PENDING: {
                return TEST_PENDING;
            }
            case ABORTED: {
                return TEST_ABORTED;
            }
        }
        return TEST_SKIPPED;
    }

    private ConsoleEvent(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }
}

