/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import java.util.Optional;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.thucydides.model.domain.Release;
import net.thucydides.model.domain.ReportNamer;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.domain.formatters.ReportFormatter;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.issues.SystemPropertiesIssueTracking;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class ReportNameProvider {
    private final Optional<String> context;
    private final ReportNamer reportNamer;
    private final RequirementsService requirementsService;
    private EnvironmentVariables environmentVariables;
    public static final Optional<String> NO_CONTEXT = Optional.empty();

    public ReportNameProvider(Optional<String> context, ReportNamer reportNamer) {
        this(context, reportNamer, ModelInfrastructure.getRequirementsService());
    }

    public ReportNameProvider(Optional<String> context, ReportNamer reportNamer, RequirementsService requirementsService) {
        this.context = context;
        this.reportNamer = reportNamer;
        this.requirementsService = requirementsService;
        this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
    }

    public ReportNameProvider(Optional<String> context, ReportType reportType, RequirementsService requirementsService) {
        this(context, ReportNamer.forReportType(reportType), requirementsService);
    }

    public ReportNameProvider getWithoutContext() {
        return new ReportNameProvider(NO_CONTEXT, this.reportNamer, this.requirementsService);
    }

    public ReportNameProvider() {
        this(NO_CONTEXT, ReportType.HTML);
    }

    public ReportNameProvider(String context) {
        this(Optional.ofNullable(context), ReportNamer.forReportType(ReportType.HTML), ModelInfrastructure.getRequirementsService());
    }

    public ReportNameProvider inContext(String context) {
        Optional<String> newContext = StringUtils.isNotEmpty((CharSequence)context) ? Optional.of(context) : NO_CONTEXT;
        return new ReportNameProvider(newContext, this.reportNamer, this.requirementsService);
    }

    protected ReportNameProvider(Optional<String> context, ReportType type) {
        this(context, ReportNamer.forReportType(type), ModelInfrastructure.getRequirementsService());
    }

    public String getContext() {
        return this.context.orElse("");
    }

    public ReportNameProvider forCSVFiles() {
        return new ReportNameProvider(this.context, ReportType.CSV);
    }

    public String forTestResult(String result) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "result_" + result);
    }

    public String forTag(String tag) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + tag.toLowerCase());
    }

    public String forErrorType(String errorType) {
        return this.reportNamer.getNormalizedReportNameFor("errortype_" + errorType.toLowerCase());
    }

    public String forTag(TestTag tag) {
        if (tag.getType().equalsIgnoreCase("issue")) {
            SystemPropertiesIssueTracking issueTracking = new SystemPropertiesIssueTracking(this.environmentVariables);
            ReportFormatter reportFormatter = new ReportFormatter(issueTracking);
            return reportFormatter.asIssueLink(tag.getName());
        }
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + tag.getType().toLowerCase() + "_" + tag.getName().toLowerCase());
    }

    public String forTagType(String tagType) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "tagtype_" + tagType.toLowerCase());
    }

    public String forRequirementType(String tagType) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "requirement_type_" + tagType.toLowerCase());
    }

    public ReportNameProvider withPrefix(String prefix) {
        return new ReportNameProvider(prefix);
    }

    public ReportNameProvider withPrefix(TestTag tag) {
        if (tag.equals(TestTag.EMPTY_TAG)) {
            return new ReportNameProvider(NO_CONTEXT, this.reportNamer, this.requirementsService);
        }
        return new ReportNameProvider(Optional.of(tag.getType().toLowerCase() + ":" + tag.getName().toLowerCase()), this.reportNamer, this.requirementsService);
    }

    private String prefixUsing(Optional<String> context) {
        if (context.isPresent() && StringUtils.isNotEmpty((CharSequence)this.getContext())) {
            return "context_" + NameConverter.underscore(context.get()) + "_";
        }
        return "";
    }

    public String forRequirement(Requirement requirement) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "requirement_" + requirement.getPath());
    }

    public String forRequirement(TestTag tag) {
        if (!this.requirementsService.getRequirementFor(tag).isPresent()) {
            return "#";
        }
        return this.forRequirement(this.requirementsService.getRequirementFor(tag).get());
    }

    public String forRequirementOrTag(TestTag tag) {
        return this.requirementsService.isRequirementsTag(tag) ? this.forRequirement(tag) : this.forTag(tag);
    }

    public String forRequirement(String requirementName, String requirementType) {
        TestTag tag = TestTag.withName(requirementName).andType(requirementType);
        return this.forRequirement(tag);
    }

    public String forRelease(Release release) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "release_" + release.getName());
    }

    public String forRelease(String releaseName) {
        return this.reportNamer.getNormalizedReportNameFor(this.prefixUsing(this.context) + "release_" + releaseName);
    }

    public ReportNameProvider inLinkableForm() {
        return new ReportNameProvider(this.context, this.reportNamer.withNoCompression(), this.requirementsService);
    }

    public String toString() {
        return "ReportNameProvider{context=" + String.valueOf(this.context) + "}";
    }
}

