/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.classpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.serenitybdd.annotations.TestAnnotations;
import net.thucydides.model.domain.TestTag;

public class AnnotatedTags {
    public static List<TestTag> forClassDefinedInPath(String path) {
        try {
            Class<?> testClass = AnnotatedTags.class.getClassLoader().loadClass(path);
            return TestAnnotations.forClass(testClass).getClassTags();
        }
        catch (ClassNotFoundException e) {
            return new ArrayList<TestTag>();
        }
    }

    public static Map<String, Collection<TestTag>> forTestMethodsDefinedInPath(String path) {
        try {
            Class<?> testClass = AnnotatedTags.class.getClassLoader().loadClass(path);
            List<String> methodNames = TestAnnotations.forClass(testClass).getTestMethodNames();
            return methodNames.stream().collect(Collectors.toMap(methodName -> methodName, methodName -> TestAnnotations.forClass(testClass).getTagsForMethod((String)methodName)));
        }
        catch (ClassNotFoundException e) {
            return new HashMap<String, Collection<TestTag>>();
        }
    }
}

