/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.PathElement;
import net.thucydides.model.domain.PathElements;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.model.CustomFieldValue;
import net.thucydides.model.requirements.model.Example;
import net.thucydides.model.requirements.model.FeatureBackgroundNarrative;
import net.thucydides.model.requirements.model.RequirementBuilderNameStep;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.NameConverter;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class Requirement
implements Comparable<Requirement> {
    private String displayName;
    private String name;
    private String id;
    private String type;
    private String path;
    private String featureFileName;
    private CustomFieldValue narrative;
    private String cardNumber;
    private List<Requirement> children;
    private String parent;
    private List<Example> examples;
    private List<String> releaseVersions;
    private List<CustomFieldValue> customFields;
    private List<TestTag> tags;
    private Map<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
    private boolean containsNoScenarios = false;
    private FeatureBackgroundNarrative background;

    public Requirement() {
        this.tags = new ArrayList<TestTag>();
        this.children = new ArrayList<Requirement>();
        this.examples = new ArrayList<Example>();
        this.releaseVersions = new ArrayList<String>();
        this.customFields = new ArrayList<CustomFieldValue>();
        this.scenarioTags = new HashMap<String, Collection<TestTag>>();
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions) {
        this(name, id, displayName, cardNumber, parent, type, "", narrative, children, examples, releaseVersions, new ArrayList<CustomFieldValue>());
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, CustomFieldValue narrative) {
        this(name, id, displayName, cardNumber, parent, type, "", narrative, new ArrayList<Requirement>(), new ArrayList<Example>(), new ArrayList<String>(), new ArrayList<CustomFieldValue>());
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields, String featureFileName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.path = this.normalized(path);
        this.parent = parent;
        this.narrative = narrative;
        this.children = children;
        this.examples = examples;
        this.releaseVersions = releaseVersions;
        this.customFields = customFields;
        this.featureFileName = featureFileName;
        this.tags = new ArrayList<TestTag>();
        this.scenarioTags = new HashMap<String, Collection<TestTag>>();
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields, String featureFileName, List<TestTag> tags, Map<String, Collection<TestTag>> scenarioTags, boolean containsNoScenarios, FeatureBackgroundNarrative background) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.path = this.normalized(path);
        this.parent = parent;
        this.narrative = narrative;
        this.children = children;
        this.examples = examples;
        this.releaseVersions = releaseVersions;
        this.customFields = customFields;
        this.featureFileName = featureFileName;
        this.tags = tags;
        this.scenarioTags = scenarioTags;
        this.containsNoScenarios = containsNoScenarios;
        this.background = background;
    }

    protected Requirement(String name, String id, String displayName, String cardNumber, String parent, String type, String path, CustomFieldValue narrative, List<Requirement> children, List<Example> examples, List<String> releaseVersions, List<CustomFieldValue> customFields) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        this.name = name;
        this.id = id;
        this.displayName = displayName != null ? displayName : name;
        this.cardNumber = cardNumber;
        this.type = type;
        this.parent = parent;
        this.narrative = narrative;
        this.children = children;
        this.examples = examples;
        this.releaseVersions = releaseVersions;
        this.customFields = customFields;
        this.path = this.normalized(path);
        this.tags = new ArrayList<TestTag>();
    }

    private String normalized(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public Requirement withNoScenarios() {
        this.containsNoScenarios = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.name;
    }

    public String getDisplayName(boolean includeParent) {
        if (includeParent) {
            String parentName = StringUtils.isNotEmpty((CharSequence)this.getParent()) ? " (" + this.getParent() + ")" : "";
            return this.getDisplayName() + parentName;
        }
        return this.getDisplayName();
    }

    public String getDisplayNameWithParent() {
        String parentName = StringUtils.isNotEmpty((CharSequence)this.getParent()) ? this.getParent() + " > " : "";
        return parentName + this.getDisplayName();
    }

    public String getType() {
        return this.type;
    }

    public String childType() {
        return !this.children.isEmpty() ? this.children.get(0).getType() : null;
    }

    public CustomFieldValue getNarrative() {
        return this.narrative;
    }

    public List<String> getReleaseVersions() {
        return this.releaseVersions;
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public String getParent() {
        return this.parent;
    }

    public List<Requirement> getChildren() {
        return this.children;
    }

    public Stream<Requirement> getChildrenAsStream() {
        return this.children.stream();
    }

    public boolean hasChild(Requirement child) {
        return this.children.contains(child);
    }

    public List<Example> getExamples() {
        return NewList.copyOf(this.examples);
    }

    public Boolean hasExamples() {
        return !this.examples.isEmpty();
    }

    public int getExampleCount() {
        return this.examples.size();
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    @Override
    public int compareTo(Requirement otherRequirement) {
        return this.getOrder().compareTo(otherRequirement.getOrder());
    }

    public static RequirementBuilderNameStep named(String name) {
        return new RequirementBuilderNameStep(name);
    }

    public Requirement definedInFile(File featureFile) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, featureFile.getName(), this.tags, this.scenarioTags, this.containsNoScenarios, this.background);
    }

    public Requirement withChildren(List<Requirement> children) {
        this.children = new ArrayList<Requirement>(children);
        return this;
    }

    public void setChildren(List<Requirement> children) {
        this.children = children;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Requirement withParent(String parent) {
        this.parent = parent;
        return this;
    }

    public Requirement withType(String type) {
        this.type = type;
        return this;
    }

    public Requirement withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Requirement withFeatureFileName(String featureFileName) {
        this.featureFileName = featureFileName;
        return this;
    }

    public Requirement withExample(Example example) {
        this.examples.add(example);
        return this;
    }

    public Requirement withExamples(List<Example> examples) {
        this.examples = examples;
        return this;
    }

    public Requirement withReleaseVersions(List<String> releaseVersions) {
        this.releaseVersions = releaseVersions;
        return this;
    }

    public Requirement withCustomFields(List<CustomFieldValue> customFields) {
        this.customFields = customFields;
        return this;
    }

    public Requirement withPath(String path) {
        this.path = path;
        return this;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Requirement> getNestedChildren() {
        ArrayList<Requirement> nestedChildren = new ArrayList<Requirement>();
        for (Requirement child : this.children) {
            nestedChildren.add(child);
            nestedChildren.addAll(child.getNestedChildren());
        }
        return NewList.copyOf(nestedChildren);
    }

    public List<TestTag> getTags() {
        return this.tags;
    }

    public Map<String, Collection<TestTag>> getScenarioTags() {
        return this.scenarioTags;
    }

    public TestTag asTag() {
        if (this.getPathElements().isEmpty()) {
            return TestTag.withName(this.qualifiedName()).andType(this.getType()).withDisplayName(NameConverter.humanize(this.displayName));
        }
        String tagName = this.getPathElements().asPath();
        String tagType = this.getType();
        return TestTag.withName(tagName).andType(tagType).withDisplayName(NameConverter.humanize(this.displayName));
    }

    public TestTag asDisplayTag() {
        if (this.getPathElements().isEmpty()) {
            return TestTag.withName(this.qualifiedName()).andType(this.getType()).withDisplayName(this.displayName);
        }
        String tagType = this.getType();
        return TestTag.withName(this.displayName).andType(tagType);
    }

    public TestTag asUnqualifiedTag() {
        return TestTag.withName(this.getName()).andType(this.getType()).withDisplayName(this.displayName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Requirement that = (Requirement)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public boolean matches(Requirement that) {
        boolean cardNumberMatches;
        boolean typesMatch;
        boolean namesMatch;
        boolean bl = this.name != null ? this.name.equals(that.name) : (namesMatch = that.name == null);
        boolean bl2 = this.type != null ? this.type.equals(that.type) : (typesMatch = that.type == null);
        boolean bl3 = StringUtils.isNotEmpty((CharSequence)this.cardNumber) ? this.cardNumber.equals(that.cardNumber) : (cardNumberMatches = that.cardNumber == null);
        boolean parentsMatch = this.parent != null ? this.parent.equals(that.parent) : that.parent == null;
        return namesMatch && typesMatch && cardNumberMatches && parentsMatch;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Requirement{name='" + this.name + "', type='" + this.type + "' parent = '" + this.parent + "', cardNumber='" + this.cardNumber + "'}";
    }

    public Requirement withChild(Requirement child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        return this;
    }

    public CustomFieldSetter withCustomField(String fieldName) {
        return new CustomFieldSetter(this, fieldName);
    }

    public List<CustomFieldValue> getCustomFieldValues() {
        return NewList.copyOf(this.customFields);
    }

    public Optional<CustomFieldValue> getCustomField(String fieldName) {
        for (CustomFieldValue field : this.customFields) {
            if (!field.getName().equals(fieldName)) continue;
            return Optional.of(field);
        }
        return Optional.empty();
    }

    public List<String> getCustomFields() {
        ArrayList<String> customFieldNames = new ArrayList<String>();
        for (CustomFieldValue field : this.customFields) {
            customFieldNames.add(field.getName());
        }
        return customFieldNames;
    }

    public String getFeatureFileName() {
        return this.featureFileName;
    }

    public String qualifiedName() {
        return StringUtils.isNotEmpty((CharSequence)this.qualifier()) ? this.qualifier() + "/" + this.getName() : this.getName();
    }

    public String qualifier() {
        return this.getParent() != null ? this.getParent() : null;
    }

    public boolean matchesTag(TestTag testTag) {
        return this.getTags().contains(testTag) || this.asTag().isAsOrMoreSpecificThan(testTag);
    }

    public Requirement merge(Requirement newRequirement) {
        String mergedCardNumber = StringUtils.isEmpty((CharSequence)this.cardNumber) ? newRequirement.cardNumber : this.cardNumber;
        String mergedDisplayName = StringUtils.isEmpty((CharSequence)this.displayName) || this.name.equalsIgnoreCase(this.displayName) ? newRequirement.displayName : this.displayName;
        String mergedNarrativeText = StringUtils.isEmpty((CharSequence)this.narrative.getText()) ? newRequirement.narrative.getText() : this.narrative.getText();
        String mergedPath = StringUtils.isEmpty((CharSequence)this.path) ? newRequirement.path : this.path;
        String mergedFeatureFileName = StringUtils.isEmpty((CharSequence)this.featureFileName) ? newRequirement.featureFileName : this.featureFileName;
        List mergedReleasVersions = ListUtils.union(this.releaseVersions, newRequirement.releaseVersions);
        List mergedExamples = ListUtils.union(this.examples, newRequirement.examples);
        List mergedCustomFields = ListUtils.union(this.customFields, newRequirement.customFields);
        List<Requirement> mergedChildren = this.mergeRequirementLists(this.children, newRequirement.children);
        return Requirement.named(this.name).withId(this.id).withOptionalParent(this.parent).withOptionalCardNumber(mergedCardNumber).withType(this.type).withNarrative(mergedNarrativeText).withPath(mergedPath).withDisplayName(mergedDisplayName).withReleaseVersions(mergedReleasVersions).withExamples(mergedExamples).withCustomFields(mergedCustomFields).withFeatureFileName(mergedFeatureFileName).withChildren(mergedChildren).withTags(this.tags).withBackground(this.background);
    }

    private List<Requirement> mergeRequirementLists(List<Requirement> existingChilden, List<Requirement> newChildren) {
        ArrayList<Requirement> mergedChildren = new ArrayList<Requirement>(existingChilden);
        for (Requirement newChild : newChildren) {
            if (mergedChildren.contains(newChild)) {
                Requirement existingChild = (Requirement)mergedChildren.remove(mergedChildren.indexOf(newChild));
                mergedChildren.add(existingChild.merge(newChild));
                continue;
            }
            mergedChildren.add(newChild);
        }
        return NewList.copyOf(mergedChildren);
    }

    public Requirement withNarrative(String narrativeText) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, new CustomFieldValue("Narrative", narrativeText), this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags, this.scenarioTags, this.containsNoScenarios, this.background);
    }

    public String getPath() {
        return this.path;
    }

    public int getDepth() {
        String separator = this.path.contains("/") ? "/" : ".";
        return this.path == null ? 0 : Splitter.on((String)separator).splitToList((CharSequence)this.path).size();
    }

    public Requirement withTags(List<TestTag> tags) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, tags, this.scenarioTags, this.containsNoScenarios, this.background);
    }

    public Requirement withScenarioTags(Map<String, Collection<TestTag>> scenarioTags) {
        if (!this.tags.isEmpty() && this.scenarioTags.isEmpty()) {
            List testTags = this.tags.stream().filter(testTag -> "tag".equals(testTag.getType())).collect(Collectors.toList());
            for (Collection<TestTag> currentScenarioTag : scenarioTags.values()) {
                currentScenarioTag.addAll(testTags);
            }
        }
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags, scenarioTags, this.containsNoScenarios, this.background);
    }

    public boolean hasTag(TestTag tag) {
        return this.getTags().contains(tag);
    }

    public boolean containsNoScenarios() {
        return this.containsNoScenarios;
    }

    public Requirement withBackground(FeatureBackgroundNarrative background) {
        return new Requirement(this.name, this.id, this.displayName, this.cardNumber, this.parent, this.type, this.path, this.narrative, this.children, this.examples, this.releaseVersions, this.customFields, this.featureFileName, this.tags, this.scenarioTags, this.containsNoScenarios, background);
    }

    public FeatureBackgroundNarrative getBackground() {
        return this.background;
    }

    public PathElements getPathElements() {
        return this.getParentPathElements();
    }

    public PathElements getParentPathElements(EnvironmentVariables environmentVariables) {
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables, "");
        if (this.path != null) {
            String relativePath = this.path;
            if (StringUtils.isNotEmpty((CharSequence)rootPath) && this.path.startsWith(rootPath)) {
                relativePath = this.path.length() > rootPath.length() ? this.path.substring(rootPath.length() + 1) : "";
            }
            String separator = relativePath.indexOf(".") > 0 ? "." : "/";
            List<PathElement> pathElements = Splitter.on((String)separator).splitToStream((CharSequence)relativePath).filter(pathElement -> !pathElement.isEmpty()).map(pathElement -> new PathElement((String)pathElement, "")).collect(Collectors.toList());
            return PathElements.from(pathElements);
        }
        return PathElements.from(Collections.emptyList());
    }

    public PathElements getParentPathElements() {
        return this.getParentPathElements(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public boolean hasParent(PathElements path) {
        return this.parent != null && this.parent.equals(path.toString());
    }

    public boolean hasParent(String path) {
        return this.parent != null && this.parent.equals(path);
    }

    public boolean matchesOrIsAParentOf(String testOutcomePath) {
        String normalizedPath = testOutcomePath.replace(".", "/");
        String packagePath = testOutcomePath.replace("/", ".");
        return normalizedPath.startsWith(this.getPath()) || packagePath.startsWith(this.getPath());
    }

    public boolean matchesUserStory(Story userStory) {
        return userStory.getPathElements().equals(this.getPathElements());
    }

    public List<TestTag> getAggregateTags() {
        ArrayList<TestTag> aggregateTags = new ArrayList<TestTag>();
        aggregateTags.addAll(this.getTags());
        aggregateTags.addAll(this.getChildren().stream().flatMap(child -> child.getAggregateTags().stream()).collect(Collectors.toList()));
        aggregateTags.addAll(this.getScenarioTags().values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        return aggregateTags;
    }

    public String getOrder() {
        return (this.path != null ? this.path : "") + (this.featureFileName != null ? this.featureFileName : "") + this.getDisplayName();
    }

    public Stream<Requirement> stream() {
        return Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(Requirement::stream));
    }

    public Collection<TestTag> tagsOfType(List<String> tagTypes) {
        return this.getTags().stream().filter(tag -> tagTypes.contains(tag.getType())).collect(Collectors.toList());
    }

    public static class CustomFieldSetter {
        Requirement requirement;
        String fieldName;

        public CustomFieldSetter(Requirement requirement, String fieldName) {
            this.requirement = requirement;
            this.fieldName = fieldName;
        }

        public Requirement setTo(String value, String renderedValue) {
            ArrayList<CustomFieldValue> customFields = new ArrayList<CustomFieldValue>(this.requirement.getCustomFieldValues());
            customFields.add(new CustomFieldValue(this.fieldName, value, renderedValue));
            this.requirement.customFields = customFields;
            return this.requirement;
        }

        public Requirement setTo(String value) {
            return this.setTo(value, null);
        }
    }
}

