/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import java.util.List;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.issues.IssueTracking;
import net.thucydides.model.issues.SystemPropertiesIssueTracking;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirmentsOutcomeFactory
implements RequirementsOutcomeFactory {
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final FileSystemRequirementsTagProvider tagProvider;
    private final ReportNameProvider reportNameProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRequirmentsOutcomeFactory.class);

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables) {
        this(environmentVariables, new SystemPropertiesIssueTracking(), new ReportNameProvider());
    }

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables, IssueTracking issueTracking, ReportNameProvider reportNameProvider) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.tagProvider = new FileSystemRequirementsTagProvider(environmentVariables);
        this.reportNameProvider = reportNameProvider;
    }

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables, IssueTracking issueTracking, ReportNameProvider reportNameProvider, String rootDirectoryPath) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.tagProvider = new FileSystemRequirementsTagProvider(environmentVariables, rootDirectoryPath);
        this.reportNameProvider = reportNameProvider;
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List<Requirement> allRequirements = this.tagProvider.getRequirements();
        LOGGER.debug("Loaded requirements from file system = " + String.valueOf(allRequirements));
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking, this.environmentVariables, NewList.of(this.tagProvider), this.reportNameProvider, this.tagProvider.getOverview().orElse(""));
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking, this.environmentVariables, NewList.of(this.tagProvider), this.reportNameProvider, "");
    }
}

