/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.model.strings.Joiner;
import org.apache.commons.lang3.StringUtils;

public class ReplaceField {
    private final String stepDescription;
    private final String field;

    public ReplaceField(String stepDescription, String field) {
        this.stepDescription = stepDescription;
        this.field = field;
    }

    public static ReplaceFieldBuilder in(String stepDescription) {
        return new ReplaceFieldBuilder(stepDescription);
    }

    public String with(Object value) {
        String fieldName = this.fieldNameFor(this.field);
        if (this.stepDescription.contains(fieldName) && value != Fields.FieldValue.UNDEFINED) {
            return StringUtils.replace((String)this.stepDescription, (String)this.fieldNameFor(this.field), (String)this.stringValueFor(value));
        }
        return this.stepDescription;
    }

    private String fieldNameFor(String field) {
        return "#" + field;
    }

    private String stringValueFor(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Enum[]) {
            return this.keyNamesFor((Enum[])value);
        }
        if (value.getClass().isArray()) {
            ArrayList<String> elements = new ArrayList<String>();
            Collections.singletonList(value).forEach(part -> elements.add(part.toString()));
            return Joiner.on(",").join((List<String>)elements);
        }
        return value.toString();
    }

    private String keyNamesFor(Enum[] keyValues) {
        ArrayList<String> keyNames = new ArrayList<String>();
        for (Enum keyValue : keyValues) {
            keyNames.add(keyValue.name());
        }
        return Joiner.on(",").join((List<String>)keyNames);
    }

    public static class ReplaceFieldBuilder {
        private String stepDescription;

        public ReplaceFieldBuilder(String stepDescription) {
            this.stepDescription = stepDescription;
        }

        public ReplaceField theFieldCalled(String field) {
            return new ReplaceField(this.stepDescription, field);
        }
    }
}

