/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.nio.file.Path;
import java.util.List;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.AggregateRequirementsService;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.Requirements;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.TestOutcomeRequirementsTagProvider;
import net.thucydides.model.requirements.reports.FileSystemRequirmentsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;

public class AggregateRequirements
implements Requirements {
    private final RequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirmentsOutcomeFactory;

    public AggregateRequirements(Path jsonOutcomes, String featureFilesDirectory) {
        this.requirementsService = new AggregateRequirementsService(ModelInfrastructure.getEnvironmentVariables(), new FileSystemRequirementsTagProvider(featureFilesDirectory), new TestOutcomeRequirementsTagProvider().fromSourceDirectory(jsonOutcomes));
        this.requirmentsOutcomeFactory = new FileSystemRequirmentsOutcomeFactory(ConfiguredEnvironment.getEnvironmentVariables(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()), featureFilesDirectory);
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirmentsOutcomeFactory;
    }

    @Override
    public RequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

