/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model.cucumber;

import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeatureParser;
import io.cucumber.core.resource.Resource;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.html.CucumberTagConverter;
import net.thucydides.model.requirements.model.FeatureBackgroundNarrative;
import net.thucydides.model.requirements.model.RequirementDefinition;
import net.thucydides.model.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.model.requirements.model.cucumber.DescriptionWithScenarioReferences;
import net.thucydides.model.requirements.model.cucumber.FeatureFileAnaysisErrors;
import net.thucydides.model.requirements.model.cucumber.InvalidFeatureFileException;
import net.thucydides.model.requirements.model.cucumber.NarrativeFromCucumberComments;
import net.thucydides.model.requirements.model.cucumber.URIResource;
import net.thucydides.model.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberParser {
    private final String locale;
    private final String encoding;
    private static final Supplier<UUID> ID_SUPPLIER = UUID::randomUUID;
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberParser.class);

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<AnnotatedFeature> loadFeature(File featureFile) {
        LOGGER.debug("Loading feature {}", (Object)featureFile.toString());
        if (featureFile == null || !featureFile.exists()) {
            return Optional.empty();
        }
        Optional<GherkinDocument> possibleGherkinDocument = this.loadCucumberFeature(featureFile.toPath());
        try {
            if (possibleGherkinDocument.isPresent() && possibleGherkinDocument.get().getFeature().isPresent()) {
                GherkinDocument gherkinDocument = possibleGherkinDocument.get();
                String descriptionInComments = NarrativeFromCucumberComments.in(gherkinDocument.getComments());
                if (this.featureFileCouldNotBeReadFor(gherkinDocument.getFeature())) {
                    return Optional.empty();
                }
                Feature feature = (Feature)gherkinDocument.getFeature().get();
                List<Scenario> scenarioList = feature.getChildren().stream().map(FeatureChild::getScenario).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                feature.getChildren().stream().map(FeatureChild::getRule).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).flatMap(rule -> rule.getChildren().stream().map(RuleChild::getScenario)).filter(Optional::isPresent).map(Optional::get).forEach(scenarioList::add);
                this.performGherkinQualityChecks(featureFile, feature, scenarioList);
                return Optional.of(new AnnotatedFeature(feature, scenarioList, descriptionInComments));
            }
            return Optional.empty();
        }
        catch (InvalidFeatureFileException invalidFeatureFile) {
            throw invalidFeatureFile;
        }
        catch (Throwable ex) {
            LOGGER.error("Invalid feature ", ex);
            return Optional.empty();
        }
    }

    private void performGherkinQualityChecks(File featureFile, Feature feature, List<Scenario> scenarioList) {
        Map<String, List<Scenario>> allScenariosByName = scenarioList.stream().collect(Collectors.groupingBy(Scenario::getName));
        ArrayList<String> errors = new ArrayList<String>();
        if (feature.getName().isEmpty()) {
            errors.add(String.format(FeatureFileAnaysisErrors.EMPTY_FEATURE_NAME, featureFile.getName()));
        }
        allScenariosByName.forEach((scenarioName, scenarios) -> this.analyseDuplicateScenarioNames((String)scenarioName, (List<Scenario>)scenarios, featureFile).ifPresent(errors::add));
        allScenariosByName.forEach((scenarioName, scenarios) -> this.analyseEmptyScenarioNames((String)scenarioName, (List<Scenario>)scenarios, featureFile).ifPresent(errors::add));
        this.analyseEmptyRuleNames(feature, featureFile).ifPresent(errors::add);
        if (!errors.isEmpty()) {
            throw new InvalidFeatureFileException(errors.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private Optional<String> analyseEmptyRuleNames(Feature feature, File featureFile) {
        List ruleList = feature.getChildren().stream().map(FeatureChild::getRule).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (ruleList.stream().anyMatch(rule -> rule.getName().isEmpty())) {
            return Optional.of(String.format(FeatureFileAnaysisErrors.EMPTY_RULE_NAME, featureFile.getName()));
        }
        return Optional.empty();
    }

    private Optional<String> analyseDuplicateScenarioNames(String scenarioName, List<Scenario> scenarios, File featureFile) throws InvalidFeatureFileException {
        if (scenarios.size() > 1) {
            return Optional.of(String.format(FeatureFileAnaysisErrors.DUPLICATE_SCENARIO_NAME, scenarioName, featureFile.getName()));
        }
        return Optional.empty();
    }

    private Optional<String> analyseEmptyScenarioNames(String scenarioName, List<Scenario> scenarios, File featureFile) throws InvalidFeatureFileException {
        if (scenarioName.isEmpty()) {
            return Optional.of(String.format(FeatureFileAnaysisErrors.EMPTY_SCENARIO_NAME, featureFile.getName()));
        }
        return Optional.empty();
    }

    private Optional<GherkinDocument> loadCucumberFeature(Path cucumberFile) {
        Optional<io.cucumber.core.gherkin.Feature> possibleFeature = this.getFeature(cucumberFile);
        ArrayList envelopes = new ArrayList();
        possibleFeature.ifPresent(feature -> feature.getParseEvents().forEach(parseEvent -> envelopes.add((Envelope)parseEvent)));
        return envelopes.stream().map(Envelope::getGherkinDocument).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).filter(gherkinDocument -> gherkinDocument.getFeature() != null && gherkinDocument.getFeature().isPresent()).findFirst();
    }

    private Optional<io.cucumber.core.gherkin.Feature> getFeature(Path cucumberFilePath) {
        URIResource cucumberResource = new URIResource(cucumberFilePath);
        try {
            return this.parseResource(cucumberResource);
        }
        catch (Throwable throwable) {
            throw new InvalidFeatureFileException("Failed to read feature file at " + String.valueOf(cucumberFilePath), throwable);
        }
    }

    public Optional<io.cucumber.core.gherkin.Feature> parseResource(Resource resource) {
        Optional optional;
        block8: {
            Objects.requireNonNull(resource);
            URI uri = resource.getUri();
            GherkinMessagesFeatureParser featureParser = new GherkinMessagesFeatureParser();
            InputStream source = resource.getInputStream();
            try {
                optional = featureParser.parse(uri, source, ID_SUPPLIER);
                if (source == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FeatureParserException("Failed to parse resource at: " + String.valueOf(uri), (Throwable)e);
                }
            }
            source.close();
        }
        return optional;
    }

    private void reportAnyCucumberSyntaxErrorsIn(Throwable gherkinError) {
        if (gherkinError instanceof FeatureParserException) {
            throw new InvalidFeatureFileException(gherkinError.getMessage(), gherkinError);
        }
    }

    public Optional<RequirementDefinition> loadFeatureDefinition(File featureFile) {
        Optional<AnnotatedFeature> loadedFeature = this.loadFeature(featureFile);
        if (!loadedFeature.isPresent()) {
            return Optional.empty();
        }
        return this.getRequirementsDefinitionFrom(loadedFeature);
    }

    @NotNull
    private synchronized Optional<RequirementDefinition> getRequirementsDefinitionFrom(Optional<AnnotatedFeature> loadedFeature) {
        Feature feature = loadedFeature.get().getFeature();
        String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(feature));
        List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(feature));
        String title = feature.getName();
        String text = this.descriptionWithScenarioReferencesFrom(feature);
        String id = this.getIdFromName(title);
        Set requirementTags = feature.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        requirementTags.add(TestTag.withName(title).andType("feature"));
        HashMap<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
        List<Scenario> scenarios = this.scenariosIn(feature);
        scenarios.forEach(scenarioDefinition -> {
            if (!scenarioDefinition.getExamples().isEmpty()) {
                List scenarioOutlineTags = scenarioDefinition.getTags();
                scenarioTags.put(scenarioDefinition.getName(), CucumberTagConverter.toSerenityTags(scenarioOutlineTags));
                List examples = scenarioDefinition.getExamples();
                for (Examples currentExample : examples) {
                    ArrayList<Tag> allExampleTags = new ArrayList<Tag>();
                    allExampleTags.addAll(scenarioOutlineTags);
                    allExampleTags.addAll(currentExample.getTags());
                    scenarioTags.put(scenarioDefinition.getName() + "_examples_at_line:" + currentExample.getLocation().getLine(), CucumberTagConverter.toSerenityTags(allExampleTags));
                }
            } else {
                scenarioTags.put(scenarioDefinition.getName(), this.tagsFrom((Scenario)scenarioDefinition));
            }
        });
        List<String> scenarioNames = scenarios.stream().map(Scenario::getName).collect(Collectors.toList());
        FeatureBackgroundNarrative background = null;
        if (this.backgroundChildIn(feature.getChildren()).isPresent()) {
            background = this.backgroundElementFrom(this.backgroundChildIn(feature.getChildren()).get().getBackground());
        }
        HashMap<String, FeatureBackgroundNarrative> ruleBackgrounds = new HashMap<String, FeatureBackgroundNarrative>();
        this.rulesIn(feature.getChildren()).forEach(rule -> {
            Optional<Background> ruleBackground = rule.getChildren().stream().map(RuleChild::getBackground).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).findFirst();
            ruleBackground.ifPresent(value -> ruleBackgrounds.put(rule.getName(), this.backgroundElementFrom(Optional.ofNullable(value))));
        });
        return Optional.of(new RequirementDefinition(Optional.of(title), Optional.of(id), Optional.ofNullable(cardNumber), versionNumbers, "feature", text != null ? text : "", new ArrayList<TestTag>(requirementTags), scenarioNames, scenarioTags).withBackground(background).withRuleBackgrounds(ruleBackgrounds));
    }

    private List<Scenario> scenariosIn(Feature feature) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        feature.getChildren().forEach(child -> {
            if (child.getRule() != null && child.getRule().isPresent()) {
                scenarios.addAll(this.scenariosIn((Rule)child.getRule().get()));
            } else if (child.getScenario() != null && child.getScenario().isPresent()) {
                scenarios.add((Scenario)child.getScenario().get());
            }
        });
        return scenarios;
    }

    private List<Scenario> scenariosIn(Rule rule) {
        return rule.getChildren().stream().filter(child -> child.getScenario() != null).map(RuleChild::getScenario).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Stream<Rule> rulesIn(List<FeatureChild> childrenList) {
        return childrenList.stream().map(FeatureChild::getRule).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<FeatureChild> backgroundChildIn(List<FeatureChild> featureChildren) {
        return featureChildren.stream().filter(featureChild -> featureChild.getBackground() != null).findFirst();
    }

    private FeatureBackgroundNarrative backgroundElementFrom(Optional<Background> background) {
        if (background.isPresent()) {
            return new FeatureBackgroundNarrative(background.get().getName(), background.get().getDescription());
        }
        return new FeatureBackgroundNarrative("", "");
    }

    private Collection<TestTag> tagsFrom(Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamples().size() == 0) {
            return this.asSerenityTags(scenarioDefinition.getTags());
        }
        HashSet<TestTag> outlineTags = new HashSet<TestTag>(this.asSerenityTags(scenarioDefinition.getTags()));
        scenarioDefinition.getExamples().forEach(examples -> outlineTags.addAll(this.asSerenityTags(examples.getTags())));
        return outlineTags;
    }

    private Set<TestTag> asSerenityTags(List<Tag> gherkinTags) {
        return gherkinTags.stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private String descriptionWithScenarioReferencesFrom(Feature feature) {
        if (feature.getDescription() == null) {
            return "";
        }
        return Arrays.stream(feature.getDescription().split("\\r?\\n")).map(line -> DescriptionWithScenarioReferences.from(feature).forText((String)line)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getIdFromName(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    private boolean featureFileCouldNotBeReadFor(Optional<Feature> feature) {
        return feature == null || !feature.isPresent();
    }

    private List<Tag> tagsDefinedIn(Feature feature) {
        return feature.getTags();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList<String> versionNumbers = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

