/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.requirements.WindowsFriendly;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootDirectory {
    private final EnvironmentVariables environmentVariables;
    private final String rootDirectoryPath;
    private static final String DEFAULT_FEATURES_ROOT_DIRECTORY = "features";
    private static final String DEFAULT_STORIES_ROOT_DIRECTORY = "stories";
    private final String featureDirectoryName;
    private final String storyDirectoryName;
    private static final Logger LOGGER = LoggerFactory.getLogger(RootDirectory.class);
    private final List<String> requirementsDirectoryNames;
    private Set<String> rootDirectoryPaths;
    private Set<String> configuredRelativeRootDirectories;
    private static final Pattern WINDOWS_PATH = Pattern.compile("([a-zA-Z]:)?(\\\\[a-zA-Z0-9_-]+)+\\\\?");
    private static Map<Path, List<File>> RESOURCE_DIRECTORY_CACHE = new HashMap<Path, List<File>>();
    private static final List<Predicate<Path>> IGNORED_DIRECTORIES = new ArrayList<Predicate<Path>>();

    RootDirectory(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this.environmentVariables = environmentVariables;
        this.rootDirectoryPath = rootDirectoryPath;
        ArrayList<String> customRequirementsDirectoryNames = new ArrayList<String>();
        ArrayList<String> defaultRequirementsDirectoryNames = new ArrayList<String>();
        this.featureDirectoryName = ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.from(environmentVariables, DEFAULT_FEATURES_ROOT_DIRECTORY);
        this.storyDirectoryName = ThucydidesSystemProperty.SERENITY_STORIES_DIRECTORY.from(environmentVariables, DEFAULT_STORIES_ROOT_DIRECTORY);
        if (ThucydidesSystemProperty.SERENITY_STORIES_DIRECTORY.isDefinedIn(environmentVariables)) {
            customRequirementsDirectoryNames.add(this.storyDirectoryName);
        } else {
            defaultRequirementsDirectoryNames.add(this.storyDirectoryName);
        }
        if (ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.isDefinedIn(environmentVariables)) {
            customRequirementsDirectoryNames.add(this.featureDirectoryName);
        } else {
            defaultRequirementsDirectoryNames.add(this.featureDirectoryName);
        }
        this.requirementsDirectoryNames = new ArrayList<String>(customRequirementsDirectoryNames);
        this.requirementsDirectoryNames.addAll(defaultRequirementsDirectoryNames);
    }

    public Set<String> requirementsDirectoryNames() {
        return new HashSet<String>(this.requirementsDirectoryNames);
    }

    public static RootDirectory definedIn(EnvironmentVariables environmentVariables) {
        return new RootDirectory(environmentVariables, ".");
    }

    public Set<String> getRootDirectoryPaths() {
        if (this.rootDirectoryPaths == null) {
            try {
                Set<String> rootDirectories = ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.isDefinedIn(this.environmentVariables) ? this.getRootDirectoryFromRequirementsBaseDir() : this.firstDefinedOf(this.getRootDirectoryFromClasspath(), this.getFileSystemDefinedDirectory(), this.getRootDirectoryFromWorkingDirectory());
                this.rootDirectoryPaths = rootDirectories.stream().map(path -> this.toAbsolute((String)path)).collect(Collectors.toSet());
            }
            catch (IOException e) {
                this.rootDirectoryPaths = new HashSet<String>();
            }
        }
        return this.rootDirectoryPaths;
    }

    private String toAbsolute(String path) {
        if (Paths.get(WindowsFriendly.formOf(path), new String[0]).isAbsolute()) {
            return path;
        }
        return Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path).toString();
    }

    public String featureDirectoryName() {
        return this.featureDirectoryName;
    }

    public String storyDirectoryName() {
        return this.storyDirectoryName;
    }

    @SafeVarargs
    private final Set<String> firstDefinedOf(Set<String> ... paths) {
        for (Set<String> path : paths) {
            if (path.isEmpty()) continue;
            return path;
        }
        return new HashSet<String>();
    }

    private Set<String> getRootDirectoryFromClasspath() throws IOException {
        ArrayList<URL> resourceRoots;
        try {
            Enumeration<URL> requirementResources = this.getDirectoriesFrom(this.rootDirectoryPath);
            resourceRoots = Collections.list(requirementResources);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return this.restoreSpacesIn(resourceRoots);
    }

    private Set<String> restoreSpacesIn(List<URL> resourceRoots) {
        HashSet<String> urlsWithRestoredSpaces = new HashSet<String>();
        for (URL resourceRoot : resourceRoots) {
            urlsWithRestoredSpaces.add(this.withRestoredSpaces(resourceRoot.getPath()));
        }
        return urlsWithRestoredSpaces;
    }

    private String withRestoredSpaces(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return StringUtils.replace((String)path, (String)"%20", (String)" ");
        }
    }

    private Set<String> getFileSystemDefinedDirectory() {
        File rootDirectoryPathFile = FileSystems.getDefault().getPath(this.rootDirectoryPath, new String[0]).toFile();
        if (rootDirectoryPathFile.exists()) {
            HashSet<String> directory = new HashSet<String>();
            directory.add(rootDirectoryPathFile.getPath());
            return directory;
        }
        return new HashSet<String>();
    }

    private Set<String> getGradleProjectDirectoryAsSet() {
        String gradleProjectDir = this.getGradleProjectDirectory();
        HashSet<String> directory = new HashSet<String>();
        if (gradleProjectDir != null) {
            if (this.rootDirectoryPath != null && this.rootDirectoryPath.startsWith(gradleProjectDir)) {
                String gradleResourceDirectory = this.rootDirectoryPath;
                directory.add(gradleResourceDirectory);
            } else if (new File(gradleProjectDir).isAbsolute()) {
                String gradleResourceDirectory = new File(gradleProjectDir, this.rootDirectoryPath).getAbsolutePath();
                directory.add(gradleResourceDirectory);
            }
        }
        return directory;
    }

    private String getGradleProjectDirectory() {
        return this.environmentVariables.getProperty("serenity.project.directory");
    }

    private Set<String> getRootDirectoryFromWorkingDirectory() {
        String workingDirectory = System.getProperty("user.dir");
        String mavenBuildDir = System.getProperty("project.build.directory");
        String gradleBuildDir = this.getGradleProjectDirectory();
        String resultDir = !StringUtils.isEmpty((CharSequence)mavenBuildDir) ? mavenBuildDir : (!StringUtils.isEmpty((CharSequence)gradleBuildDir) ? gradleBuildDir : workingDirectory);
        return this.getRootDirectoryFromParentDir(resultDir);
    }

    private Set<String> getRootDirectoryFromRequirementsBaseDir() {
        if (this.configuredRelativeRootDirectories == null) {
            this.configuredRelativeRootDirectories = this.getRootDirectoryFromParentDir(ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.from(this.environmentVariables, ""));
        }
        return this.configuredRelativeRootDirectories;
    }

    private Set<String> getRootDirectoryFromParentDir(String parentDir) {
        List<File> resourceDirectories = RootDirectory.getResourceDirectories(Paths.get(parentDir, new String[0]), this.environmentVariables);
        HashSet<String> directoryPaths = new HashSet<String>();
        for (File resourceDirectory : resourceDirectories) {
            if (new File(resourceDirectory, this.rootDirectoryPath).exists()) {
                directoryPaths.add(new File(resourceDirectory, this.rootDirectoryPath).getAbsolutePath());
            }
            if (new File(resourceDirectory, this.featureDirectoryName).exists()) {
                directoryPaths.add(new File(resourceDirectory, this.featureDirectoryName).getAbsolutePath());
            }
            if (!new File(resourceDirectory, this.storyDirectoryName).exists()) continue;
            directoryPaths.add(new File(resourceDirectory, this.storyDirectoryName).getAbsolutePath());
        }
        return directoryPaths;
    }

    private Enumeration<URL> getDirectoriesFrom(String root) throws IOException, URISyntaxException {
        String rootWithEscapedSpaces = root.replaceAll(" ", "%20");
        URI rootUri = this.isWindowsPath(rootWithEscapedSpaces) ? new File(root).toPath().toUri() : new URI(rootWithEscapedSpaces);
        return this.getClass().getClassLoader().getResources(rootUri.getPath());
    }

    private boolean isWindowsPath(String rootWithEscapedSpaces) {
        return WINDOWS_PATH.matcher(rootWithEscapedSpaces).find();
    }

    public Optional<Path> featuresOrStoriesRootDirectory() {
        String relativeRoot;
        String string = relativeRoot = this.rootDirectoryPath.equals(".") ? "" : this.rootDirectoryPath;
        if (ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return Optional.of(Paths.get(ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.from(this.environmentVariables), new String[0]));
        }
        List<File> resourceDirectories = RootDirectory.getResourceDirectories(Paths.get(relativeRoot, new String[0]), this.environmentVariables);
        List resourceDirectoriesByIncreasingDepth = resourceDirectories.stream().sorted(Comparator.comparingInt(dir -> dir.getAbsolutePath().length())).collect(Collectors.toList());
        for (File resourceDir : resourceDirectoriesByIncreasingDepth) {
            for (String candidateDirectoryName : this.requirementsDirectoryNames) {
                if (!new File(resourceDir, candidateDirectoryName).exists()) continue;
                return Optional.of(resourceDir.toPath().resolve(candidateDirectoryName));
            }
        }
        return Optional.empty();
    }

    private static List<File> getResourceDirectories(Path root, EnvironmentVariables environmentVariables) {
        if (RESOURCE_DIRECTORY_CACHE.containsKey(root)) {
            return RESOURCE_DIRECTORY_CACHE.get(root);
        }
        List<File> results = ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.isDefinedIn(environmentVariables) ? new ArrayList<File>() : RootDirectory.listDirectories(root).parallelStream().filter(path -> path.endsWith("src/test/resources")).map(Path::toFile).collect(Collectors.toList());
        RESOURCE_DIRECTORY_CACHE.put(root, results);
        return results;
    }

    private static List<Path> listDirectories(Path path) {
        ArrayList<Path> files = new ArrayList<Path>();
        if (RootDirectory.isResourceDirectoryCandidate(path)) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path entry : stream) {
                    if (!RootDirectory.isResourceDirectoryCandidate(entry)) continue;
                    files.add(entry);
                    files.addAll(RootDirectory.listDirectories(entry));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return files;
    }

    private static boolean isResourceDirectoryCandidate(Path entry) {
        try {
            if (entry.toString().isEmpty()) {
                return true;
            }
            if (!Files.isDirectory(entry, new LinkOption[0])) {
                return false;
            }
            if (Files.isHidden(entry)) {
                return false;
            }
            return IGNORED_DIRECTORIES.stream().noneMatch(shouldIgnore -> shouldIgnore.test(entry));
        }
        catch (IOException e) {
            return false;
        }
    }

    Path getRelativePathOf(String path) {
        if (path == null) {
            return Paths.get("", new String[0]);
        }
        for (String requirementsDirectory : this.requirementsDirectoryNames) {
            if (path.startsWith("classpath:" + requirementsDirectory + "/")) {
                return Paths.get(path.substring(requirementsDirectory.length() + 11), new String[0]);
            }
            if (!this.relativePathFromAbsolutePath(path, requirementsDirectory).isPresent()) continue;
            return this.relativePathFromAbsolutePath(path, requirementsDirectory).get();
        }
        if (path.startsWith("classpath:")) {
            return Paths.get(path.substring(10), new String[0]);
        }
        return new File(path).toPath();
    }

    private Optional<Path> relativePathFromAbsolutePath(String absolutePath, String requirementsDirectory) {
        if (absolutePath.startsWith("file:/")) {
            String requirementsDirectoryInPath = "/" + requirementsDirectory + "/";
            if (absolutePath.contains(requirementsDirectoryInPath)) {
                int startOfRelativePath = absolutePath.lastIndexOf(requirementsDirectoryInPath) + requirementsDirectoryInPath.length();
                return Optional.of(Paths.get(absolutePath.substring(startOfRelativePath), new String[0]));
            }
        } else if (absolutePath.startsWith("file:")) {
            return Optional.of(Paths.get(absolutePath.substring(5), new String[0]));
        }
        return Optional.empty();
    }

    static {
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().startsWith("."));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("target"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("build"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("out"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("java"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("scala"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("groovy"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals("kotlin"));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals(DEFAULT_FEATURES_ROOT_DIRECTORY));
        IGNORED_DIRECTORIES.add(path -> path.getFileName().toString().equals(DEFAULT_STORIES_ROOT_DIRECTORY));
    }
}

