/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import java.util.List;
import net.thucydides.model.issues.IssueTracking;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.AggregateRequirementsService;
import net.thucydides.model.requirements.BaseRequirementsService;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirmentsOutcomeFactory
implements RequirementsOutcomeFactory {
    private static final String EMPTY_OVERVIEW = "";
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final BaseRequirementsService requirementsService;
    private final ReportNameProvider reportNameProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRequirmentsOutcomeFactory.class);

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables, IssueTracking issueTracking, ReportNameProvider reportNameProvider, String rootDirectoryPath) {
        this(environmentVariables, issueTracking, reportNameProvider, new AggregateRequirementsService(environmentVariables, new FileSystemRequirementsTagProvider(rootDirectoryPath, environmentVariables)));
    }

    public FileSystemRequirmentsOutcomeFactory(EnvironmentVariables environmentVariables, IssueTracking issueTracking, ReportNameProvider reportNameProvider, BaseRequirementsService requirementsService) {
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.reportNameProvider = reportNameProvider;
        this.requirementsService = requirementsService;
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List<Requirement> allRequirements = this.requirementsService.getRequirements();
        LOGGER.debug("Loaded requirements from file system = " + String.valueOf(allRequirements));
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsService.getRequirementsTagProviders(), this.reportNameProvider, this.getOverview());
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsService.getRequirementsTagProviders(), this.reportNameProvider, EMPTY_OVERVIEW);
    }

    private String getOverview() {
        for (RequirementsTagProvider requirementsTagProvider : this.requirementsService.getRequirementsTagProviders()) {
            if (!(requirementsTagProvider instanceof FileSystemRequirementsTagProvider)) continue;
            return requirementsTagProvider.getOverview().orElse(EMPTY_OVERVIEW);
        }
        return EMPTY_OVERVIEW;
    }
}

