/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.integration;

import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestStep;

public class TestStepFactory {
    public static TestStep successfulTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.SUCCESS);
    }

    public static TestStep failingTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.FAILURE);
    }

    public static TestStep errorTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.ERROR);
    }

    public static TestStep skippedTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.SKIPPED);
    }

    public static TestStep ignoredTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.IGNORED);
    }

    public static TestStep pendingTestStepCalled(String description) {
        return TestStepFactory.createNewTestStep(description, TestResult.PENDING);
    }

    public static TestStep flakyTestStepCalled(String description) {
        return TestStepFactory.createNewFlakyTestStep(description);
    }

    private static TestStep createNewTestStep(String description, TestResult result) {
        TestStep step = new TestStep(description);
        step.setResult(result);
        return step;
    }

    private static TestStep createNewFlakyTestStep(String description) {
        return TestStep.forStepCalled(description).withResult(TestResult.UNDEFINED);
    }
}

