/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import net.thucydides.model.domain.TestResult;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.reports.AcceptanceCriteriaRequirmentCounter;
import net.thucydides.model.requirements.reports.ChildRequirementCounter;
import net.thucydides.model.requirements.reports.RequirmentCalculator;
import net.thucydides.model.requirements.reports.SubrequirementsPercentageCount;
import net.thucydides.model.requirements.reports.SubrequirementsProportionCount;

public class SubrequirementsCount {
    private final Requirement requirement;
    private final TestOutcomes testOutcomes;

    public SubrequirementsCount(Requirement requirement, TestOutcomes testOutcomes) {
        this.requirement = requirement;
        this.testOutcomes = testOutcomes;
    }

    public SubrequirementsProportionCount getProportion() {
        return new SubrequirementsProportionCount(this);
    }

    public SubrequirementsPercentageCount getPercentage() {
        return new SubrequirementsPercentageCount(this);
    }

    public long getTotal() {
        return this.requirement.hasChildren() ? this.usingChildRequirements().countAllSubrequirements() : this.usingAcceptanceCriteria().countAllSubrequirements();
    }

    public long withResult(String resultValue) {
        TestResult result = TestResult.valueOf(resultValue.toUpperCase());
        return this.requirement.hasChildren() ? this.usingChildRequirements().countSubrequirementsWithResult(result) : this.usingAcceptanceCriteria().countSubrequirementsWithResult(result);
    }

    public long withNoTests() {
        return this.requirement.hasChildren() ? this.usingChildRequirements().countSubrequirementsWithNoTests() : this.usingAcceptanceCriteria().countSubrequirementsWithNoTests();
    }

    private RequirmentCalculator usingChildRequirements() {
        return new ChildRequirementCounter(this.requirement, this.testOutcomes);
    }

    private RequirmentCalculator usingAcceptanceCriteria() {
        return new AcceptanceCriteriaRequirmentCounter(this.testOutcomes);
    }

    public String toString() {
        return "SubrequirementsCount{requirement=" + String.valueOf(this.requirement) + ", testOutcomes=" + String.valueOf(this.testOutcomes) + "}";
    }
}

