/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.matchers.BeanCollectionMatcher;
import net.thucydides.model.matchers.dates.BeanFields;
import org.hamcrest.Matcher;

public class MinFieldValueMatcher
implements BeanCollectionMatcher {
    private final String fieldName;
    private final Matcher<? extends Comparable> valueMatcher;

    public MinFieldValueMatcher(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        List fieldValues = elements.stream().map(element -> (Comparable)BeanFields.fieldValueIn(element).forField(this.fieldName)).collect(Collectors.toList());
        return this.valueMatcher.matches(Collections.min(fieldValues));
    }

    public String toString() {
        return "the minimum " + this.fieldName + " " + this.valueMatcher.toString();
    }

    @Override
    public boolean matches(Object target) {
        return this.matches((Collection)target);
    }
}

