/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MethodFinder {
    private final Class targetClass;

    private MethodFinder(Class targetClass) {
        this.targetClass = targetClass;
    }

    public static MethodFinder inClass(Class targetClass) {
        return new MethodFinder(targetClass);
    }

    public List<Method> getAllMethods() {
        HashSet<Method> allMethods = new HashSet<Method>();
        allMethods.addAll(Arrays.asList(this.targetClass.getDeclaredMethods()));
        allMethods.addAll(Arrays.asList(this.targetClass.getMethods()));
        this.addParentMethods(allMethods, this.targetClass);
        return new ArrayList<Method>(allMethods);
    }

    private void addParentMethods(Set<Method> allMethods, Class targetClass) {
        if (targetClass.getSuperclass() != null) {
            allMethods.addAll(Arrays.asList(targetClass.getSuperclass().getDeclaredMethods()));
            this.addParentMethods(allMethods, targetClass.getSuperclass());
        }
    }

    public Method getMethodNamed(String methodName) {
        List<Method> methods = this.getAllMethods();
        Method methodFound = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            methodFound = method;
        }
        return methodFound;
    }

    public Method getMethodNamed(String methodName, List<Object> arguments) {
        List methodsFilteredByName = this.getAllMethods().stream().filter(m -> Objects.equals(methodName, m.getName())).collect(Collectors.toList());
        if (methodsFilteredByName.isEmpty()) {
            return null;
        }
        Class[] argumentTypes = (Class[])arguments.stream().map(a -> a == null ? null : a.getClass()).toArray(Class[]::new);
        Method foundMethod = methodsFilteredByName.stream().filter(m -> Arrays.equals(m.getParameterTypes(), argumentTypes)).findFirst().orElse(null);
        if (foundMethod == null) {
            foundMethod = methodsFilteredByName.stream().filter(m -> m.getParameterTypes().length == argumentTypes.length).findFirst().orElse((Method)methodsFilteredByName.get(0));
        }
        return foundMethod;
    }
}

