/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thucydides.model.util.Acronym;
import net.thucydides.model.util.Inflection;
import net.thucydides.model.util.MultipleInflection;
import org.apache.commons.lang3.StringUtils;

public class Inflector {
    private static final Inflector INSTANCE = new Inflector();
    private LinkedList<Rule> plurals = new LinkedList();
    private LinkedList<Rule> singulars = new LinkedList();
    private final Set<String> uncountables = new HashSet<String>();
    private final String NON_BLANK_SEPARATORS = "-+_/:;&()";
    private static final Pattern LOWER_CAMEL_CASE = Pattern.compile("[a-z]+((\\d)|([A-Z0-9][a-z0-9]+))*([A-Z])?");
    private static final Pattern UPPER_CAMEL_CASE = Pattern.compile("^[A-Z][a-zA-Z0-9]*$");

    public static Inflector getInstance() {
        return INSTANCE;
    }

    public static Inflector inflection() {
        return Inflector.getInstance();
    }

    public Inflection of(String word) {
        return new Inflection(word, this);
    }

    public MultipleInflection of(int count) {
        return new MultipleInflection(count, this);
    }

    public MultipleInflection of(long count) {
        return new MultipleInflection(count, this);
    }

    public Inflector() {
        this.initialize();
    }

    public String pluralize(Object word) {
        if (word == null) {
            return null;
        }
        String wordStr = word.toString().trim();
        if (wordStr.length() == 0) {
            return wordStr;
        }
        if (this.isUncountable(wordStr)) {
            return wordStr;
        }
        for (Rule rule : this.plurals) {
            String result = rule.apply(wordStr);
            if (result == null) continue;
            return result;
        }
        return wordStr;
    }

    public String pluralize(Object word, long count) {
        if (word == null) {
            return null;
        }
        if (count == 1L || count == -1L) {
            return word.toString();
        }
        return this.pluralize(word);
    }

    public String singularize(Object word) {
        if (word == null) {
            return null;
        }
        String wordStr = word.toString().trim();
        if (wordStr.length() == 0) {
            return wordStr;
        }
        if (this.isUncountable(wordStr)) {
            return wordStr;
        }
        for (Rule rule : this.singulars) {
            String result = rule.apply(wordStr);
            if (result == null) continue;
            return result;
        }
        return wordStr;
    }

    public String capitalize(String words) {
        if (words == null) {
            return null;
        }
        String result = words.trim();
        if (result.length() == 0) {
            return "";
        }
        if (result.length() == 1) {
            return result.toUpperCase();
        }
        return Character.toUpperCase(result.charAt(0)) + result.substring(1).toLowerCase();
    }

    public String firstUpperCase(String words) {
        if (words == null) {
            return null;
        }
        String result = words.trim();
        if (result.length() == 0) {
            return "";
        }
        if (result.length() == 1) {
            return result.toUpperCase();
        }
        StringBuilder capitalisedPhrase = new StringBuilder();
        StringBuilder currentWord = new StringBuilder();
        if (this.startsWithQuote(words)) {
            capitalisedPhrase.append(words.charAt(0));
        } else {
            currentWord.append(words.charAt(0));
        }
        for (int i = 1; i < words.length(); ++i) {
            if (!this.isNonBlankSeparator(words.charAt(i))) {
                currentWord.append(words.charAt(i));
                continue;
            }
            capitalisedPhrase.append(StringUtils.capitalize((String)currentWord.toString())).append(words.charAt(i));
            currentWord = new StringBuilder();
        }
        capitalisedPhrase.append(StringUtils.capitalize((String)currentWord.toString()));
        String completeWord = capitalisedPhrase.toString();
        return StringUtils.capitalize((String)completeWord);
    }

    private boolean startsWithQuote(String word) {
        return word.charAt(0) == '\'' || word.charAt(0) == '\"';
    }

    private boolean isNonBlankSeparator(char c) {
        return "-+_/:;&()".contains(String.valueOf(c));
    }

    public String humanize(String lowerCaseAndUnderscoredWords, String ... removableTokens) {
        if (this.isCamelCase(lowerCaseAndUnderscoredWords)) {
            lowerCaseAndUnderscoredWords = this.underscore(lowerCaseAndUnderscoredWords, new char[0]);
        }
        String result = this.humanReadableFormOf(lowerCaseAndUnderscoredWords, removableTokens);
        Set<Acronym> acronyms = Acronym.acronymsIn(result);
        result = result.toLowerCase();
        for (Acronym acronym : acronyms) {
            result = acronym.restoreIn(result);
        }
        return StringUtils.capitalize((String)result);
    }

    private boolean isCamelCase(String text) {
        return LOWER_CAMEL_CASE.matcher(text).matches() || UPPER_CAMEL_CASE.matcher(text).matches();
    }

    private String humanReadableFormOf(String lowerCaseAndUnderscoredWords, String ... removableTokens) {
        if (lowerCaseAndUnderscoredWords == null) {
            return null;
        }
        String result = lowerCaseAndUnderscoredWords.trim();
        if (result.length() == 0) {
            return "";
        }
        result = result.replaceAll("_id$", "");
        if (removableTokens != null) {
            for (String removableToken : removableTokens) {
                result = result.replaceAll(removableToken, "");
            }
        }
        result = result.replaceAll("_+", " ");
        return result;
    }

    public String underscore(String camelCaseWord, char ... delimiterChars) {
        if (camelCaseWord == null) {
            return null;
        }
        String result = camelCaseWord.trim();
        if (result.length() == 0) {
            return "";
        }
        result = result.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2");
        result = result.replaceAll("([a-z\\d])([A-Z])", "$1_$2");
        if (delimiterChars != null) {
            for (char delimiterChar : delimiterChars) {
                result = result.replace(delimiterChar, '_');
            }
        }
        return result.toLowerCase();
    }

    public String kebabCase(String camelCaseWord, char ... delimiterChars) {
        return this.underscore(camelCaseWord, delimiterChars).replaceAll("_", "-");
    }

    String titleCase(String words, String ... removableTokens) {
        String humanizedForm = this.humanize(words, removableTokens);
        String result = Arrays.stream(humanizedForm.split("\\s")).map(this::firstUpperCase).collect(Collectors.joining(" "));
        return result.trim();
    }

    private boolean isUncountable(String word) {
        String trimmedLower = word.trim().toLowerCase();
        return this.uncountables.contains(trimmedLower);
    }

    private void addPluralize(String rule, String replacement) {
        Rule pluralizeRule = new Rule(rule, replacement);
        this.plurals.addFirst(pluralizeRule);
    }

    private void addSingularize(String rule, String replacement) {
        Rule singularizeRule = new Rule(rule, replacement);
        this.singulars.addFirst(singularizeRule);
    }

    private void addIrregular(String singular, String plural) {
        String singularRemainder = singular.length() > 1 ? singular.substring(1) : "";
        String pluralRemainder = plural.length() > 1 ? plural.substring(1) : "";
        this.addPluralize("(" + singular.charAt(0) + ")" + singularRemainder + "$", "$1" + pluralRemainder);
        this.addSingularize("(" + plural.charAt(0) + ")" + pluralRemainder + "$", "$1" + singularRemainder);
    }

    private void addUncountable(String ... words) {
        for (String word : words) {
            this.uncountables.add(word.trim().toLowerCase());
        }
    }

    private static String replaceAllWithUppercase(String input, String regex, int groupNumberToUppercase) {
        Pattern underscoreAndDotPattern = Pattern.compile(regex);
        Matcher matcher = underscoreAndDotPattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(groupNumberToUppercase).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected void initialize() {
        this.addPluralize("$", "s");
        this.addPluralize("s$", "s");
        this.addPluralize("(ax|test)is$", "$1es");
        this.addPluralize("(octop|vir)us$", "$1i");
        this.addPluralize("(octop|vir)i$", "$1i");
        this.addPluralize("(alias|status)$", "$1es");
        this.addPluralize("(bu)s$", "$1ses");
        this.addPluralize("(buffal|tomat)o$", "$1oes");
        this.addPluralize("([ti])um$", "$1a");
        this.addPluralize("([ti])a$", "$1a");
        this.addPluralize("sis$", "ses");
        this.addPluralize("(?:([^f])fe|([lr])f)$", "$1$2ves");
        this.addPluralize("(hive)$", "$1s");
        this.addPluralize("([^aeiouy]|qu)y$", "$1ies");
        this.addPluralize("(x|ch|ss|sh)$", "$1es");
        this.addPluralize("(matr|vert|ind)ix|ex$", "$1ices");
        this.addPluralize("([m|l])ouse$", "$1ice");
        this.addPluralize("([m|l])ice$", "$1ice");
        this.addPluralize("^(ox)$", "$1en");
        this.addPluralize("(quiz)$", "$1zes");
        this.addPluralize("(people|men|children|sexes|moves|stadiums)$", "$1");
        this.addPluralize("(oxen|octopi|viri|aliases|quizzes)$", "$1");
        this.addSingularize("s$", "");
        this.addSingularize("(s|si|u)s$", "$1s");
        this.addSingularize("(n)ews$", "$1ews");
        this.addSingularize("([ti])a$", "$1um");
        this.addSingularize("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        this.addSingularize("(^analy)ses$", "$1sis");
        this.addSingularize("(^analy)sis$", "$1sis");
        this.addSingularize("([^f])ves$", "$1fe");
        this.addSingularize("(hive)s$", "$1");
        this.addSingularize("(tive)s$", "$1");
        this.addSingularize("([lr])ves$", "$1f");
        this.addSingularize("([^aeiouy]|qu)ies$", "$1y");
        this.addSingularize("(s)eries$", "$1eries");
        this.addSingularize("(m)ovies$", "$1ovie");
        this.addSingularize("(x|ch|ss|sh)es$", "$1");
        this.addSingularize("([m|l])ice$", "$1ouse");
        this.addSingularize("(bus)es$", "$1");
        this.addSingularize("(o)es$", "$1");
        this.addSingularize("(shoe)s$", "$1");
        this.addSingularize("(cris|ax|test)is$", "$1is");
        this.addSingularize("(cris|ax|test)es$", "$1is");
        this.addSingularize("(octop|vir)i$", "$1us");
        this.addSingularize("(octop|vir)us$", "$1us");
        this.addSingularize("(alias|status)es$", "$1");
        this.addSingularize("(alias|status)$", "$1");
        this.addSingularize("^(ox)en", "$1");
        this.addSingularize("(vert|ind)ices$", "$1ex");
        this.addSingularize("(matr)ices$", "$1ix");
        this.addSingularize("(quiz)zes$", "$1");
        this.addIrregular("person", "people");
        this.addIrregular("man", "men");
        this.addIrregular("child", "children");
        this.addIrregular("sex", "sexes");
        this.addIrregular("move", "moves");
        this.addIrregular("stadium", "stadiums");
        this.addUncountable("equipment", "information", "rice", "money", "species", "series", "fish", "sheep");
    }

    protected static class Rule {
        protected final String expression;
        final Pattern expressionPattern;
        final String replacement;

        protected Rule(String expression, String replacement) {
            this.expression = expression;
            this.replacement = replacement;
            this.expressionPattern = Pattern.compile(this.expression, 2);
        }

        protected String apply(String input) {
            Matcher matcher = this.expressionPattern.matcher(input);
            if (!matcher.find()) {
                return null;
            }
            return matcher.replaceAll(this.replacement);
        }
    }
}

