/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.statistics.service;

import java.util.HashSet;
import java.util.Set;
import net.serenitybdd.model.collect.NewSet;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.domain.features.ApplicationFeature;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.CoreTagProvider;
import net.thucydides.model.statistics.service.TagProvider;
import net.thucydides.model.util.EnvironmentVariables;

public class FeatureStoryTagProvider
implements TagProvider,
CoreTagProvider {
    private final EnvironmentVariables environmentVariables;

    public FeatureStoryTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public FeatureStoryTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        this.addStoryTagIfPresent(testOutcome, tags);
        this.addFeatureTagIfPresent(testOutcome, tags);
        return NewSet.copyOf(tags);
    }

    private void addStoryTagIfPresent(TestOutcome testOutcome, Set<TestTag> tags) {
        Story story = testOutcome.getUserStory();
        if (story != null && this.shouldAddStoryTags()) {
            tags.add(story.asTag());
        }
    }

    private boolean shouldAddStoryTags() {
        return ThucydidesSystemProperty.USE_TEST_CASE_FOR_STORY_TAG.booleanFrom(this.environmentVariables, true);
    }

    private void addFeatureTagIfPresent(TestOutcome testOutcome, Set<TestTag> tags) {
        ApplicationFeature feature = testOutcome.getFeature();
        if (feature != null) {
            tags.add(TestTag.withName(feature.getName()).andType("feature"));
        }
    }
}

