/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain.features;

import com.google.common.base.Preconditions;
import net.thucydides.model.util.NameConverter;

public class ApplicationFeature {
    private final String id;
    private final String name;

    public ApplicationFeature(String id, String name) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)name);
        this.id = id;
        this.name = name;
    }

    protected ApplicationFeature(Class<?> featureClass) {
        Preconditions.checkNotNull(featureClass);
        this.id = featureClass.getCanonicalName();
        this.name = NameConverter.humanize(featureClass.getSimpleName());
    }

    public String getName() {
        return this.name;
    }

    public static ApplicationFeature from(Class<?> featureClass) {
        return new ApplicationFeature(featureClass);
    }

    public String getId() {
        return this.id;
    }

    private boolean idAndNameAreEqual(ApplicationFeature that) {
        if (this.featureIdIsDifferent(that)) {
            return false;
        }
        return !this.featureNameIsDifferent(that);
    }

    private boolean featureIdIsDifferent(ApplicationFeature that) {
        return !this.getId().equals(that.id);
    }

    private boolean featureNameIsDifferent(ApplicationFeature that) {
        return !this.getName().equals(that.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationFeature)) {
            return false;
        }
        ApplicationFeature that = (ApplicationFeature)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

