/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.time;

import java.time.ZonedDateTime;
import net.serenitybdd.model.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalSystemClock
implements SystemClock {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalSystemClock.class);

    @Override
    public void pauseFor(long timeInMilliseconds) {
        try {
            this.sleepFor(timeInMilliseconds);
        }
        catch (InterruptedException e) {
            LOGGER.error("Wait interrupted:" + e.getMessage());
            throw new RuntimeException("System timer interrupted", e);
        }
    }

    protected void sleepFor(long timeInMilliseconds) throws InterruptedException {
        Thread.sleep(timeInMilliseconds);
    }

    @Override
    public ZonedDateTime getCurrentTime() {
        return ZonedDateTime.now();
    }
}

