/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers.dates;

import net.thucydides.model.matchers.dates.DateMatcherFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class DateTimeIsCloseToAsMatcher
extends TypeSafeMatcher<DateTime> {
    private final DateTime expectedDate;
    private final DateTime minimumDate;
    private final DateTime maximumDate;
    private final Period margin;

    public DateTimeIsCloseToAsMatcher(DateTime expected, Period margin) {
        this.expectedDate = expected;
        this.margin = margin;
        this.minimumDate = this.expectedDate.minus((ReadablePeriod)margin);
        this.maximumDate = this.expectedDate.plus((ReadablePeriod)margin);
    }

    public boolean matchesSafely(DateTime specifiedDate) {
        return !specifiedDate.isBefore((ReadableInstant)this.minimumDate) && !specifiedDate.isAfter((ReadableInstant)this.maximumDate);
    }

    public void describeTo(Description description) {
        description.appendText("a date that is within " + this.margin.toString() + " of ");
        description.appendText(DateMatcherFormatter.formatted(this.expectedDate));
    }
}

