/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.requirements.model.FeatureBackgroundNarrative;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RequirementDefinition {
    private final Optional<String> title;
    private final Optional<String> id;
    private final Optional<String> cardNumber;
    private final List<String> versionNumbers;
    private final String text;
    private String type;
    private List<TestTag> tags;
    private List<String> scenarios = new ArrayList<String>();
    private Map<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
    private FeatureBackgroundNarrative background;
    private Map<String, FeatureBackgroundNarrative> ruleBackgrounds = new HashMap<String, FeatureBackgroundNarrative>();

    public RequirementDefinition(Optional<String> title, Optional<String> id, Optional<String> cardNumber, List<String> versionNumbers, String type, String text) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)text);
        this.title = title;
        this.id = id;
        this.cardNumber = cardNumber;
        this.versionNumbers = versionNumbers;
        this.type = type;
        this.text = text;
        this.tags = new ArrayList<TestTag>();
    }

    public RequirementDefinition(Optional<String> title, Optional<String> id, Optional<String> cardNumber, List<String> versionNumbers, String type, String text, List<TestTag> tags) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)text);
        this.title = title;
        this.id = id;
        this.cardNumber = cardNumber;
        this.versionNumbers = versionNumbers;
        this.type = type;
        this.text = text;
        this.tags = new ArrayList<TestTag>(tags);
        this.scenarios = new ArrayList<String>();
        this.scenarioTags = new HashMap<String, Collection<TestTag>>();
    }

    public RequirementDefinition(Optional<String> title, Optional<String> id, Optional<String> cardNumber, List<String> versionNumbers, String type, String text, List<TestTag> tags, List<String> scenarios, Map<String, Collection<TestTag>> scenarioTags) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)text);
        this.title = title;
        this.id = id;
        this.cardNumber = cardNumber;
        this.versionNumbers = versionNumbers;
        this.type = type;
        this.text = text;
        this.tags = new ArrayList<TestTag>(tags);
        this.scenarios = scenarios;
        this.scenarioTags = scenarioTags;
    }

    public RequirementDefinition(String type, String text) {
        this(Optional.empty(), Optional.empty(), Optional.empty(), NewList.of(new String[0]), type, text);
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getCardNumber() {
        return this.cardNumber;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getVersionNumbers() {
        return NewList.copyOf(this.versionNumbers);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("title", this.title).append("text", (Object)this.text).append("type", (Object)this.type).toString();
    }

    public List<String> getScenarios() {
        return this.scenarios;
    }

    public List<TestTag> getTags() {
        return this.tags;
    }

    public Map<String, Collection<TestTag>> getScenarioTags() {
        return this.scenarioTags;
    }

    public RequirementDefinition withBackground(FeatureBackgroundNarrative background) {
        this.background = background;
        return this;
    }

    public RequirementDefinition withRuleBackgrounds(Map<String, FeatureBackgroundNarrative> ruleBackgrounds) {
        this.ruleBackgrounds = ruleBackgrounds;
        return this;
    }

    public Optional<FeatureBackgroundNarrative> background() {
        return Optional.ofNullable(this.background);
    }

    public Optional<FeatureBackgroundNarrative> ruleBackgroundForRule(String ruleName) {
        return Optional.ofNullable(this.ruleBackgrounds.get(ruleName));
    }
}

