/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import net.thucydides.model.domain.TestTag;

public class TagMatch {
    private final String excludedTagExpression;

    public TagMatch(String excludedTagExpression) {
        this.excludedTagExpression = excludedTagExpression;
    }

    public static TagMatch excluding(String excludedTagExpression) {
        return new TagMatch(excludedTagExpression);
    }

    public boolean matches(TestTag tag) {
        if (tag.equals(TestTag.withValue(this.excludedTagExpression))) {
            return true;
        }
        if (this.excludedTagExpression.endsWith(":*")) {
            String tagType = this.excludedTagExpression.replace(":*", "").trim();
            return tag.getType().trim().equalsIgnoreCase(tagType.trim());
        }
        if (this.excludedTagExpression.startsWith("*:")) {
            String tagValue = this.excludedTagExpression.replace("*:", "").trim();
            return tag.getName().trim().equalsIgnoreCase(tagValue.trim());
        }
        return false;
    }
}

