/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.requirements.DefaultCapabilityTypes;
import net.thucydides.model.requirements.RootDirectory;
import net.thucydides.model.requirements.model.RequirementTypeAt;
import net.thucydides.model.util.EnvironmentVariables;

public class RequirementsConfiguration {
    private static final String DEFAULT_ROOT_DIRECTORY = "/features";
    private final EnvironmentVariables environmentVariables;
    private final Optional<Path> root;
    private final String rootPackage;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.root = RootDirectory.definedIn(environmentVariables).featuresOrStoriesRootDirectory();
        this.rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables, "");
    }

    public RequirementsConfiguration(EnvironmentVariables environmentVariables, String rootDirectory) {
        this.environmentVariables = environmentVariables;
        this.root = Optional.of(this.absolutePathOfDirectoryOnClasspath(rootDirectory));
        this.rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables, "");
    }

    private Path absolutePathOfDirectoryOnClasspath(String rootDirectory) {
        URL rootDirOnClasspath = this.getClass().getClassLoader().getResource(rootDirectory);
        Path absolutePath = Paths.get(rootDirectory, new String[0]);
        if (rootDirOnClasspath != null) {
            try {
                absolutePath = Paths.get(rootDirOnClasspath.toURI());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Fail to build absolute path of directory on classpath", e);
            }
        }
        return absolutePath;
    }

    public List<String> getRequirementTypes() {
        return DefaultCapabilityTypes.instance().getRequirementTypes(this.environmentVariables, this.root);
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.SERENITY_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public String getRequirementType(int level) {
        return RequirementTypeAt.level(level).in(this.getRequirementTypes());
    }

    public String getRequirementType(int level, int maxDepth) {
        List<String> applicableRequirements = new ArrayList<String>(this.getRequirementTypes());
        applicableRequirements = maxDepth < this.getRequirementTypes().size() ? applicableRequirements.subList(0, maxDepth) : this.getRequirementTypes();
        return RequirementTypeAt.level(level).in(applicableRequirements);
    }

    public int startLevelForADepthOf(int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes().size() - requirementsDepth);
    }

    public String getRootPackage() {
        return this.rootPackage;
    }

    public String getRootDirectory() {
        return this.root.map(Path::toString).orElseGet(this::getDefaultRootDirectory);
    }

    public String relativePathOfFeatureFile(File featureFilePath) {
        if (this.root.isPresent() && featureFilePath.getPath().contains(this.root.get().toString())) {
            int rootPathLength = this.root.get().toString().length();
            String relativePath = featureFilePath.getPath().substring(featureFilePath.getPath().indexOf(this.root.get().toString()) + rootPathLength + 1);
            return relativePath.substring(0, relativePath.lastIndexOf("."));
        }
        return featureFilePath.getPath().substring(0, featureFilePath.getPath().lastIndexOf("."));
    }
}

