/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.Writer;
import java.util.Map;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.templates.TemplateManager;

public class Merger {
    final String templateFile;
    final TemplateManager templateManager;

    public Merger(String templateFile) {
        this.templateFile = templateFile;
        this.templateManager = (TemplateManager)Injectors.getInjector().getInstance(TemplateManager.class);
    }

    public MergeBuilder withContext(Map<String, Object> context) {
        return new MergeBuilder(context, this.templateManager, this.templateFile);
    }

    public static class MergeBuilder {
        private final Map<String, Object> context;
        private final TemplateManager templateManager;
        private final String templateFile;

        public MergeBuilder(Map<String, Object> context, TemplateManager templateManager, String templateFile) {
            this.context = context;
            this.templateManager = templateManager;
            this.templateFile = templateFile;
        }

        public void to(Writer writer) {
            try {
                this.templateManager.getTemplateFrom(this.templateFile).merge(this.context, writer);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to merge template: " + e.getMessage(), e);
            }
        }
    }
}

