/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.TimeoutConfiguration;
import net.thucydides.core.configuration.TimeoutValue;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.reports.NumberOfThreads;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.core.reports.html.ReportExecutor;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.ThreadDump;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Reporter {
    private static final TimeoutValue DEFAULT_TIMEOUT = new TimeoutValue(600L, TimeUnit.SECONDS);
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAggregateStoryReporter.class);
    private final Collection<ReportingTask> reportingTasks;
    private final EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();

    private Reporter(Collection<ReportingTask> reportingTasks) {
        this.reportingTasks = reportingTasks;
    }

    public static void generateReportsFor(Collection<ReportingTask> reportingTasks) {
        new Reporter(reportingTasks).generateReports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReports() {
        Stopwatch stopwatch = Stopwatch.started();
        ExecutorService executorPool = Executors.newFixedThreadPool(NumberOfThreads.forIOOperations());
        ErrorTally errorTally = new ErrorTally();
        try {
            List partitions = this.reportingTasks.stream().map(ReportExecutor::new).collect(Collectors.toList());
            List futures = partitions.stream().map(partition -> new ReportExecutorFuture(executorPool.submit(partition), partition.getReportingTask())).collect(Collectors.toList());
            TimeoutValue timeout = TimeoutConfiguration.from((EnvironmentVariables)this.environmentVariables).forProperty("report.timeout", DEFAULT_TIMEOUT);
            for (ReportExecutorFuture executedTask : futures) {
                String errorMessage;
                try {
                    executedTask.getFuture().get(timeout.getTimeout(), timeout.getUnit());
                }
                catch (TimeoutException reportGenerationTimedOut) {
                    errorMessage = this.reportFailureMessage("Report generation timed out", executedTask, reportGenerationTimedOut);
                    errorTally.recordReportFailure(errorMessage);
                    LOGGER.warn(errorMessage);
                }
                catch (InterruptedException reportGenerationInterrupted) {
                    errorMessage = this.reportFailureMessage("Report generation interrupted", executedTask, reportGenerationInterrupted);
                    errorTally.recordReportFailure(errorMessage);
                    LOGGER.warn(errorMessage);
                }
                catch (ExecutionException reportGenerationFailed) {
                    errorMessage = this.reportFailureMessage("Failed to generate report", executedTask, reportGenerationFailed);
                    errorTally.recordReportFailure(errorMessage);
                    LOGGER.warn(errorMessage, (Throwable)reportGenerationFailed);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Report generation failed", (Throwable)e);
        }
        finally {
            executorPool.shutdown();
        }
        LOGGER.debug("Test outcome reports generated in {} ms", (Object)stopwatch.stop());
        if (errorTally.hasErrors()) {
            LOGGER.warn(errorTally.errorSummary());
            if (this.showThreaddumpOnReportTimeout()) {
                System.err.println("REPORT GENERATION STACK DUMP");
                System.err.println(ThreadDump.forAllThreads());
            }
        }
    }

    private String ultimateError(Throwable cause) {
        if (cause.getCause() == null) {
            return cause.getMessage();
        }
        return this.ultimateError(cause.getCause());
    }

    private boolean showThreaddumpOnReportTimeout() {
        return ThucydidesSystemProperty.REPORT_TIMEOUT_THREADDUMPS.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }

    private String reportFailureMessage(String reason, ReportExecutorFuture executedTask, Exception e) {
        return String.format("%s for %s - %s\n%s", reason, executedTask, e, this.errorCauseOf(e));
    }

    private String errorCauseOf(Throwable e) {
        if (e.getCause() != null) {
            return this.ultimateError(e) + System.lineSeparator() + this.topElementFrom(e.getCause().getStackTrace());
        }
        return this.ultimateError(e) + System.lineSeparator() + this.topElementFrom(e.getStackTrace());
    }

    private String topElementFrom(StackTraceElement[] elements) {
        if (elements.length == 0) {
            return "";
        }
        return elements[0].toString();
    }

    static class ReportExecutorFuture {
        private final Future<Void> future;
        private final ReportingTask reportTask;

        ReportExecutorFuture(Future<Void> future, ReportingTask reportTask) {
            this.future = future;
            this.reportTask = reportTask;
        }

        Future<Void> getFuture() {
            return this.future;
        }

        public String toString() {
            return this.reportTask.toString();
        }
    }

    private class ErrorTally {
        private final List<ErrorRecord> errors = new ArrayList<ErrorRecord>();

        private ErrorTally() {
        }

        boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        void recordReportFailure(String errorMessage) {
            String threadDump = Reporter.this.showThreaddumpOnReportTimeout() ? ThreadDump.forAllThreads() : "";
            this.errors.add(new ErrorRecord(errorMessage, threadDump));
        }

        String errorSummary() {
            StringBuilder errorMessage = new StringBuilder("SOME REPORT PAGES COULD NOT BE GENERATED\n");
            for (ErrorRecord error : this.errors) {
                errorMessage.append(" * ").append(error.message).append("\n").append(error.threadDump).append("\n");
            }
            return errorMessage.toString();
        }
    }

    private static class ErrorRecord {
        public final String message;
        public final String threadDump;

        private ErrorRecord(String message, String threadDump) {
            this.message = message;
            this.threadDump = threadDump;
        }
    }
}

