/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;

public class DurationReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String TEST_OUTCOME_TEMPLATE_PATH = "freemarker/outcomes-with-result.ftl";
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;
    final TestOutcomes testOutcomes;
    final ReportNameProvider reportNameProvider;
    final TestTag tag;
    final String duration;
    final String reportName;

    public DurationReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, TestOutcomes testOutcomes, ReportNameProvider reportNameProvider, TestTag tag, String duration) {
        super(freemarker, environmentVariables, outputDirectory);
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
        this.testOutcomes = testOutcomes;
        this.reportNameProvider = reportNameProvider;
        this.tag = tag;
        this.duration = duration;
        this.reportName = reportNameProvider.withPrefix(tag).forTag(TestTag.withName((String)duration).andType("Duration"));
    }

    @Override
    public void generateReports() throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(this.testOutcomes, this.reportNameProvider, true);
        context.put("report", ReportProperties.forTestResultsReport());
        context.put("currentTagType", this.tag.getType());
        context.put("currentTag", this.tag);
        String csvReport = this.reportNameProvider.forCSVFiles().forTag(TestTag.withName((String)this.duration).andType("Duration"));
        context.put("csvReport", csvReport);
        this.generateReportPage(context, TEST_OUTCOME_TEMPLATE_PATH, this.reportName);
        this.generateCSVReportFor(this.testOutcomes, csvReport);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationReportingTask that = (DurationReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DurationReportingTask{");
        sb.append("reportName='").append(this.reportName).append('\'').append('}');
        return sb.toString();
    }

    @Override
    public String reportName() {
        return this.reportName;
    }
}

