/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.DuplicateRequirementNames;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.requirements.reports.ScenarioOutcomes;
import net.thucydides.core.tags.OutcomeTagFilter;
import net.thucydides.core.util.EnvironmentVariables;

class RequirementsTypeReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String REQUIREMENT_TYPE_TEMPLATE_PATH = "freemarker/requirement-type.ftl";
    private final ReportNameProvider reportNameProvider;
    private final RequirementsOutcomes requirementsOutcomes;
    private final String requirementType;
    private final String reportName;

    private RequirementsTypeReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomes requirementsOutcomes, String requirementType) {
        super(freemarker, environmentVariables, outputDirectory);
        this.reportNameProvider = reportNameProvider;
        this.requirementsOutcomes = requirementsOutcomes;
        this.requirementType = requirementType;
        this.reportName = reportNameProvider.forRequirementType(requirementType);
    }

    static Stream<ReportingTask> requirementTypeReports(List<String> requirementTypes, RequirementsOutcomes requirementsOutcomes, FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider) {
        return requirementTypes.stream().map(type -> new RequirementsTypeReportingTask(freemarker, environmentVariables, outputDirectory, reportNameProvider, requirementsOutcomes, (String)type));
    }

    @Override
    public void generateReports() throws IOException {
        Map<String, Object> context = this.freemarker.getBuildContext(this.requirementsOutcomes.getTestOutcomes(), this.reportNameProvider, true);
        OutcomeTagFilter scenarioOutcomeFilter = new OutcomeTagFilter(this.environmentVariables);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("requirementType", this.requirementType);
        RequirementsOutcomes filteredRequirementsOutcomes = this.requirementsOutcomes.requirementsOfType(this.requirementType).filteredByDisplayTag();
        context.put("requirements", filteredRequirementsOutcomes);
        context.put("duplicateRequirementNamesPresent", DuplicateRequirementNames.presentIn(filteredRequirementsOutcomes));
        List scenarios = scenarioOutcomeFilter.scenariosFilteredByTagIn(ScenarioOutcomes.from((RequirementsOutcomes)this.requirementsOutcomes));
        context.put("scenarios", scenarios);
        this.generateReportPage(context, REQUIREMENT_TYPE_TEMPLATE_PATH, this.reportName);
    }

    @Override
    public String reportName() {
        return this.reportName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementsTypeReportingTask that = (RequirementsTypeReportingTask)o;
        return Objects.equal((Object)this.reportName, (Object)that.reportName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.reportName});
    }
}

