/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html.accessibility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.html.accessibility.RGB;
import net.thucydides.core.util.EnvironmentVariables;

public class ChartColorScheme {
    private final EnvironmentVariables environmentVariables;
    private static final List<TestResult> CHART_STATUS_VALUES = Arrays.asList(TestResult.SUCCESS, TestResult.PENDING, TestResult.IGNORED, TestResult.SKIPPED, TestResult.ABORTED, TestResult.FAILURE, TestResult.ERROR, TestResult.COMPROMISED);
    private static final List<String> STANDARD_COLORS = Arrays.asList("'rgba(153,204,51,0.5)'", "'rgba(165, 199, 238, 0.5)'", "'rgba(168, 168, 168, 0.5)'", "'rgba(238, 224, 152, 0.75)'", "'rgba(255, 153, 102, 0.5)'", "'rgba(255, 22, 49, 0.5)'", "'rgba(255, 97, 8, 0.5)'", "'rgba(255, 104, 255, 0.5)'", "'rgba(83, 50, 168, 0.5)'");
    private static final List<String> ACCESSIBLE_COLORS = Arrays.asList("'rgba(153,204,51,0.5)'", "pattern.draw('line', 'rgba(165, 199, 238, 0.5)')", "pattern.draw('line-vertical', 'rgba(168, 168, 168, 0.5)')", "pattern.draw('diagonal', 'rgba(238, 224, 152, 0.75)')", "pattern.draw('diagonal-right-left', 'rgba(255, 153, 102, 0.5)')", "pattern.draw('zigzag-vertical', 'rgba(255, 22, 49, 0.5)')", "pattern.draw('zigzag', 'rgba(255, 97, 8, 0.5)')", "pattern.draw('square', 'rgba(255, 104, 255, 0.5)')", "pattern.draw('diamond', 'rgba(83, 50, 168, 0.5)')");
    private static final List<String> STANDARD_MANUAL_COLORS = Arrays.asList("'rgba(153,204,51,0.25)'", "'rgba(165, 199, 238, 0.25)'", "'rgba(168, 168, 168, 0.25)'", "'rgba(238, 224, 152, 0.375)'", "'rgba(255, 153, 102, 0.25)'", "'rgba(255, 22, 49, 0.25)'", "'rgba(255, 97, 8, 0.25)'", "'rgba(255, 104, 255, 0.25)'", "'rgba(83, 50, 168, 0.25)'");
    private static final List<String> ACCESSIBLE_MANUAL_COLORS = Arrays.asList("'rgba(153,204,51,0.25)'", "pattern.draw('line', 'rgba(165, 199, 238, 0.25)')", "pattern.draw('line-vertical', 'rgba(168, 168, 168, 0.25)')", "pattern.draw('diagonal', 'rgba(238, 224, 152, 0.375)')", "pattern.draw('diagonal-right-left', 'rgba(255, 153, 102, 0.25)')", "pattern.draw('zigzag-vertical', 'rgba(255, 22, 49, 0.25)')", "pattern.draw('zigzag', 'rgba(255, 97, 8, 0.25)')", "pattern.draw('triangle', 'rgba(255, 104, 255, 0.25)')", "pattern.draw('diamond', 'rgba(83, 50, 168, 0.25)')");
    private static final List<String> BORDER_COLORS = Arrays.asList("'rgba(153,204,51,1)'", "'rgba(165, 199, 238, 1)'", "'rgba(168, 168, 168, 1)'", "'rgba(238, 224, 152, 1)'", "'rgba(255, 153, 102, 1)'", "'rgba(255, 22, 49, 1)'", "'rgba(255, 97, 8, 1)'", "'rgba(255, 104, 255, 1)'", "'rgba(83, 50, 168, 1)'");
    private static final Map<EnvironmentVariables, ChartColorScheme> COLOR_SCHEMES = new HashMap<EnvironmentVariables, ChartColorScheme>();

    public ChartColorScheme(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public static ChartColorScheme forEnvironment(EnvironmentVariables environmentVariables) {
        if (!COLOR_SCHEMES.containsKey(environmentVariables)) {
            COLOR_SCHEMES.put(environmentVariables, new ChartColorScheme(environmentVariables));
        }
        return COLOR_SCHEMES.get(environmentVariables);
    }

    public String backgroundColorFor(String testStatus) {
        int valueIndex = CHART_STATUS_VALUES.indexOf(TestResult.valueOf((String)testStatus));
        if (this.isInAccessibleMode()) {
            return ACCESSIBLE_COLORS.get(valueIndex);
        }
        return STANDARD_COLORS.get(valueIndex);
    }

    public String getBackgroundColors() {
        if (this.isInAccessibleMode()) {
            return this.formatted(ACCESSIBLE_COLORS);
        }
        return this.formatted(STANDARD_COLORS);
    }

    public String gradientColors(RGB start, RGB end, int steps) {
        RGB diff = start.minus(end);
        double alphaInc = diff.getAlpha() / ((double)steps * 1.0);
        int redInc = (int)Math.round((double)diff.getRed() / ((double)steps * 1.0));
        int greenInc = (int)Math.round((double)diff.getGreen() / ((double)steps * 1.0));
        int blueInc = (int)Math.round((double)diff.getBlue() / ((double)steps * 1.0));
        RGB colorStep = new RGB(redInc, greenInc, blueInc, alphaInc);
        ArrayList<RGB> gradientColors = new ArrayList<RGB>();
        RGB color = start;
        for (int i = 0; i < steps; ++i) {
            gradientColors.add(color);
            color = color.minus(colorStep);
        }
        return this.formatted(gradientColors.stream().map(rgb -> "'" + rgb.toString() + "'").collect(Collectors.toList()));
    }

    public String getManualBackgroundColors() {
        if (this.isInAccessibleMode()) {
            return this.formatted(ACCESSIBLE_MANUAL_COLORS);
        }
        return this.formatted(STANDARD_MANUAL_COLORS);
    }

    public String getBorderColors() {
        return this.formatted(BORDER_COLORS);
    }

    private String formatted(List<String> colors) {
        return "[" + colors.stream().collect(Collectors.joining(",")) + "]";
    }

    private boolean isInAccessibleMode() {
        return Boolean.parseBoolean(EnvironmentSpecificConfiguration.from((EnvironmentVariables)this.environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_REPORT_ACCESSIBILITY).orElse("false"));
    }
}

