/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Map;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.thucydides.core.reports.html.CopyProjectSpecificResourcesTask;
import net.thucydides.core.reports.html.HtmlResourceCopier;
import net.thucydides.core.reports.html.Merger;
import net.thucydides.core.reports.html.TestOutcomeTimestamp;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.logging.ConsoleColors;
import net.thucydides.model.logging.LoggingLevel;
import net.thucydides.model.reports.ThucydidesReporter;
import net.thucydides.model.reports.templates.TemplateManager;
import net.thucydides.model.reports.util.CopyDirectory;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HtmlReporter
extends ThucydidesReporter {
    private static final String DEFAULT_RESOURCE_DIRECTORY = "report-resources";
    private static final String DEFAULT_SOURCE_DIR = "target/site/serenity";
    private String resourceDirectory = "report-resources";
    private final TemplateManager templateManager = ModelInfrastructure.getTemplateManager();
    protected final EnvironmentVariables environmentVariables;
    protected final ConsoleColors colored;
    protected static final String TIMESTAMP_FORMAT = "dd-MM-yyyy HH:mm:ss";
    protected static final String READABLE_TIMESTAMP_FORMAT = "MMM dd, yyyy HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReporter.class);

    public HtmlReporter() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public HtmlReporter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.colored = new ConsoleColors(environmentVariables);
    }

    public void setResourceDirectory(String resourceDirectory) {
        this.resourceDirectory = resourceDirectory;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    protected EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    protected void copyResourcesToOutputDirectory() throws IOException {
        this.updateResourceDirectoryFromSystemPropertyIfDefined();
        HtmlResourceCopier.copyHtmlResourcesFrom(this.getResourceDirectory()).to(this.getOutputDirectory());
        this.copyProjectSpecificResources();
    }

    private void copyProjectSpecificResources() throws IOException {
        CopyProjectSpecificResourcesTask projectSpecificResourceCopier = new CopyProjectSpecificResourcesTask();
        projectSpecificResourceCopier.setResourceDirectory(this.resourceDirectory);
        projectSpecificResourceCopier.setOutputDirectory(this.getOutputDirectory());
        projectSpecificResourceCopier.setSourceDirectory(this.getSourceDirectory());
        projectSpecificResourceCopier.generateReports();
    }

    protected void copyTestResultsToOutputDirectory() throws IOException {
        Path sourcePath = this.getSourceDirectoryOrDefault().toPath();
        Path destinationPath = this.getOutputDirectory().toPath();
        if (Files.exists(sourcePath, new LinkOption[0]) && !Files.isSameFile(sourcePath, destinationPath)) {
            LOGGER.trace("Copying directory contents from {} to {}", (Object)sourcePath, (Object)destinationPath);
            this.copyDirectoryContents(sourcePath, destinationPath);
            LOGGER.trace("Copying directory contents from {} to {} done", (Object)sourcePath, (Object)destinationPath);
        }
    }

    private void copyDirectoryContents(Path sourcePath, Path destinationPath) throws IOException {
        Files.walkFileTree(sourcePath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new CopyDirectory(sourcePath, destinationPath));
    }

    private File getSourceDirectoryOrDefault() {
        String source = this.getSourceDirectory() != null ? this.getSourceDirectory().getAbsolutePath() : DEFAULT_SOURCE_DIR;
        return new File(source);
    }

    private void updateResourceDirectoryFromSystemPropertyIfDefined() {
        String systemDefinedResourceDirectory = ThucydidesSystemProperty.SERENITY_REPORT_RESOURCES.from(this.environmentVariables);
        if (systemDefinedResourceDirectory != null) {
            this.setResourceDirectory(systemDefinedResourceDirectory);
        }
    }

    protected void addTimestamp(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("timestamp", TestOutcomeTimestamp.from(testOutcome));
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    protected Boolean verboseReporting() {
        return LoggingLevel.definedIn((EnvironmentVariables)this.environmentVariables).isAtLeast(LoggingLevel.VERBOSE);
    }
}

