/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.reports.html.RequirementsOverviewReportingTask;
import net.thucydides.core.reports.html.RequirementsTypeReportingTask;
import net.thucydides.model.releases.ReleaseManager;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.RequirementsConfiguration;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.util.EnvironmentVariables;

public class RequirementsReports {
    private final ReportNameProvider reportNameProvider;
    private final RequirementsOutcomeFactory requirementsFactory;
    private ReleaseManager releaseManager;
    private final String relativeLink;
    private final RequirementsService requirementsService;
    private final RequirementsConfiguration requirementsConfiguration;
    private final TestOutcomes testOutcomes;
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;

    public RequirementsReports(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomeFactory requirementsFactory, RequirementsService requirementsService, String relativeLink, TestOutcomes testOutcomes) {
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
        this.reportNameProvider = reportNameProvider;
        this.requirementsFactory = requirementsFactory;
        this.requirementsService = requirementsService;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.testOutcomes = testOutcomes;
        this.relativeLink = relativeLink;
    }

    public static Stream<ReportingTask> requirementsReportsFor(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory, ReportNameProvider reportNameProvider, RequirementsOutcomeFactory requirementsFactory, RequirementsService requirementsService, String relativeLink, TestOutcomes testOutcomes, RequirementsOutcomes requirementsOutcomes) throws IOException {
        RequirementsReports reporter = new RequirementsReports(freemarker, environmentVariables, outputDirectory, reportNameProvider, requirementsFactory, requirementsService, relativeLink, testOutcomes);
        return Stream.of(RequirementsTypeReportingTask.requirementTypeReports(requirementsService.getRequirementTypes(), requirementsOutcomes, freemarker, environmentVariables, outputDirectory, reportNameProvider), Stream.of(new RequirementsOverviewReportingTask(freemarker, environmentVariables, outputDirectory, reportNameProvider, requirementsService, requirementsOutcomes.withoutUnrelatedRequirements(), relativeLink, testOutcomes).asParentRequirement()), reporter.reportsForChildRequirements(requirementsOutcomes)).flatMap(stream -> stream);
    }

    private Stream<ReportingTask> reportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) throws IOException {
        return requirementsOutcomes.getRequirementOutcomes().stream().flatMap(outcome -> {
            Requirement requirement = outcome.getRequirement();
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().forRequirement(requirement);
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement).withoutUnrelatedRequirements();
            return this.nestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement);
        });
    }

    private Stream<ReportingTask> nestedRequirementsReportsFor(Requirement parentRequirement, RequirementsOutcomes requirementsOutcomes) {
        return Stream.concat(Stream.of(new RequirementsOverviewReportingTask(this.freemarker, this.environmentVariables, this.outputDirectory, this.reportNameProvider, this.requirementsService, requirementsOutcomes, this.relativeLink, requirementsOutcomes.getTestOutcomes(), this.reportNameProvider.forRequirement(parentRequirement)).asLeafRequirement()), this.requirementsReportsForChildRequirements(requirementsOutcomes));
    }

    private Stream<ReportingTask> requirementsReportsForChildRequirements(RequirementsOutcomes requirementsOutcomes) {
        return requirementsOutcomes.getRequirementOutcomes().stream().flatMap(outcome -> {
            Requirement requirement = outcome.getRequirement();
            TestOutcomes testOutcomesForThisRequirement = outcome.getTestOutcomes().forRequirement(requirement);
            RequirementsOutcomes requirementOutcomesForThisRequirement = this.requirementsFactory.buildRequirementsOutcomesFrom(requirement, testOutcomesForThisRequirement).withoutUnrelatedRequirements();
            return this.nestedRequirementsReportsFor(requirement, requirementOutcomesForThisRequirement);
        });
    }

    public List<String> getRequirementTypes() {
        List types = this.requirementsService.getRequirementTypes();
        if (types.isEmpty()) {
            return this.requirementsConfiguration.getRequirementTypes();
        }
        return types;
    }
}

