/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.filter.Filter;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.ProxySpecification;
import io.restassured.specification.RequestSpecification;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.rest.RestMethod;
import net.serenitybdd.rest.decorators.request.RequestSpecificationAdvancedConfiguration;
import net.serenitybdd.rest.stubs.ResponseStub;
import net.serenitybdd.rest.utils.RestDecorationHelper;
import net.serenitybdd.rest.utils.RestExecutionHelper;
import net.thucydides.core.steps.StepEventBus;
import org.apache.http.client.HttpClient;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestSpecificationDecorated
extends RequestSpecificationAdvancedConfiguration
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationDecorated.class);
    private Response lastResponse;

    public RequestSpecificationDecorated(RequestSpecificationImpl core) {
        super(core);
    }

    public Response get() {
        return this.get("", new Object[0]);
    }

    public Response get(URL url) {
        return this.get(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response get(String path, Object ... pathParams) {
        return this.execute(RestMethod.GET, path, pathParams);
    }

    public Response request(String method, URI uri) {
        return this.execute(RestMethod.valueOf((String)method), uri.getPath(), new Object[0]);
    }

    public Response request(String method, URL url) {
        return this.execute(RestMethod.valueOf((String)method), url.getPath(), new Object[0]);
    }

    public Response request(RestMethod method, String path, Object ... pathParams) {
        return this.execute(method, path, pathParams);
    }

    public Response request(String method, String path, Object ... pathParams) {
        return this.execute(RestMethod.valueOf((String)method), path, pathParams);
    }

    public Response request(RestMethod method, URI uri) {
        return this.execute(method, uri.getPath(), new Object[0]);
    }

    public Response request(RestMethod method, URL url) {
        return this.execute(method, url.getPath(), new Object[0]);
    }

    public Response get(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.get(path, new Object[0]);
    }

    public Response get(URI uri) {
        return this.get(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response post() {
        return this.post("", new Object[0]);
    }

    public Response post(URL url) {
        return this.post(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response post(String path, Object ... pathParams) {
        return this.execute(RestMethod.POST, path, pathParams);
    }

    public Response post(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.post(path, new Object[0]);
    }

    public Response post(URI uri) {
        return this.post(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response put() {
        return this.put("", new Object[0]);
    }

    public Response put(URL url) {
        return this.put(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response put(URI uri) {
        return this.put(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response put(String path, Object ... pathParams) {
        return this.execute(RestMethod.PUT, path, pathParams);
    }

    public Response put(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.put(path, new Object[0]);
    }

    public Response delete() {
        return this.delete("", new Object[0]);
    }

    public Response delete(URL url) {
        return this.delete(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response delete(URI uri) {
        return this.delete(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response delete(String path, Object ... pathParams) {
        return this.execute(RestMethod.DELETE, path, pathParams);
    }

    public Response delete(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.delete(path, new Object[0]);
    }

    public Response head() {
        return this.head("", new Object[0]);
    }

    public Response head(URL url) {
        return this.head(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response head(URI uri) {
        return this.head(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response head(String path, Object ... pathParams) {
        return this.execute(RestMethod.HEAD, path, pathParams);
    }

    public Response head(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.head(path, new Object[0]);
    }

    public Response patch() {
        return this.patch("", new Object[0]);
    }

    public Response patch(URL url) {
        return this.patch(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    public Response patch(URI uri) {
        return this.patch(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response patch(String path, Object ... pathParams) {
        return this.execute(RestMethod.PATCH, path, pathParams);
    }

    public Response patch(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.patch(path, new Object[0]);
    }

    public Response options() {
        return this.options("", new Object[0]);
    }

    public Response options(String path, Object ... pathParams) {
        return this.execute(RestMethod.OPTIONS, path, pathParams);
    }

    public Response options(String path, Map<String, ?> pathParams) {
        this.pathParameters((Map)pathParams);
        return this.options(path, new Object[0]);
    }

    public Response options(URI uri) {
        return this.options(((URI)Args.notNull((Object)uri, (String)"URI")).toString(), new Object[0]);
    }

    public Response options(URL url) {
        return this.options(((URL)Args.notNull((Object)url, (String)"URL")).toString(), new Object[0]);
    }

    protected Response execute(RestMethod method, String path, Object ... pathParams) {
        Response response = null;
        RuntimeException exception = null;
        try {
            response = this.executeCall(method, path, pathParams);
            if (RestExecutionHelper.restCallsAreDisabled()) {
                response = this.stubbed();
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (exception != null) {
            this.reportError(method, path, exception, pathParams);
            if (Serenity.shouldThrowErrorsImmediately()) {
                throw exception;
            }
            response = this.stubbed();
        } else {
            this.reportQuery(method, path, response, pathParams);
        }
        this.lastResponse = response;
        return response;
    }

    private void reportQuery(RestMethod method, String path, Response response, Object[] pathParams) {
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            this.reporting.registerCall(method, response, this, path, pathParams);
        } else {
            log.info("No BaseStepListener, {} {} not registered.", (Object)method.toString(), (Object)path);
        }
    }

    private void reportError(RestMethod method, String path, RuntimeException exception, Object[] pathParams) {
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            this.reporting.registerCall(method, this, path, exception, pathParams);
        } else {
            log.info("No BaseStepListener, {} {} not registered.", (Object)method.toString(), (Object)path);
        }
    }

    private Response executeCall(RestMethod method, String path, Object[] pathParams) {
        switch (method) {
            case POST: {
                return this.decorate(this.core.post(path, pathParams));
            }
            case GET: {
                return this.decorate(this.core.get(path, pathParams));
            }
            case DELETE: {
                return this.decorate(this.core.delete(path, pathParams));
            }
            case PUT: {
                return this.decorate(this.core.put(path, pathParams));
            }
            case HEAD: {
                return this.decorate(this.core.head(path, pathParams));
            }
            case OPTIONS: {
                return this.decorate(this.core.options(path, pathParams));
            }
            case PATCH: {
                return this.decorate(this.core.patch(path, pathParams));
            }
        }
        throw new IllegalArgumentException("Unknown REST query type: " + method);
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    private Response stubbed() {
        return new ResponseStub();
    }

    public RequestSpecification filter(Filter filter) {
        return RestDecorationHelper.decorate(this.core.filter(filter));
    }

    public List<Filter> getDefinedFilters() {
        return this.core.getDefinedFilters();
    }

    public String getContentType() {
        return this.core.getContentType();
    }

    public ProxySpecification getProxySpecification() {
        return this.core.getProxySpecification();
    }

    public AuthenticationScheme getAuthenticationScheme() {
        return this.core.getAuthenticationScheme();
    }

    public String getBasePath() {
        return this.core.getBasePath();
    }

    public String getBaseUri() {
        return this.core.getBaseUri();
    }

    public String getDerivedPath() {
        return this.core.getDerivedPath();
    }

    public String getUserDefinedPath() {
        return this.core.getUserDefinedPath();
    }

    public String getMethod() {
        return this.core.getMethod();
    }

    public String getURI() {
        return this.core.getURI();
    }

    public int getPort() {
        return this.core.getPort();
    }

    public Map<String, String> getRequestParams() {
        return this.core.getRequestParams();
    }

    public Map<String, String> getFormParams() {
        return this.core.getFormParams();
    }

    public Map<String, String> getPathParams() {
        return this.core.getPathParams();
    }

    public Map<String, String> getNamedPathParams() {
        return this.core.getNamedPathParams();
    }

    public Map<String, String> getUnnamedPathParams() {
        return this.core.getUnnamedPathParams();
    }

    public List<String> getUnnamedPathParamValues() {
        return this.core.getUnnamedPathParamValues();
    }

    public Map<String, String> getQueryParams() {
        return this.core.getQueryParams();
    }

    public <T> T getBody() {
        return (T)this.core.getBody();
    }

    public HttpClient getHttpClient() {
        return this.core.getHttpClient();
    }

    public List<String> getUndefinedPathParamPlaceholders() {
        return this.core.getUndefinedPathParamPlaceholders();
    }

    public List<String> getPathParamPlaceholders() {
        return this.core.getPathParamPlaceholders();
    }
}

