/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import com.google.common.base.Preconditions;
import io.restassured.http.ContentType;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.mapper.ObjectMapper;
import io.restassured.mapper.ObjectMapperType;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.io.InputStream;
import net.serenitybdd.rest.HeaderNames;
import net.serenitybdd.rest.decorators.request.RequestSpecificationHeaderConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationBodyConfigurations
extends RequestSpecificationHeaderConfigurations
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationBodyConfigurations.class);

    public RequestSpecificationBodyConfigurations(RequestSpecificationImpl core) {
        super(core);
    }

    public RequestSpecification body(Object object) {
        this.core.body(object);
        return this;
    }

    public RequestSpecification body(Object object, ObjectMapper mapper) {
        if (object instanceof byte[]) {
            this.core.body((byte[])object);
        } else {
            this.core.body(object, mapper);
        }
        return this;
    }

    public RequestSpecification body(Object object, ObjectMapperType mapperType) {
        if (object instanceof byte[]) {
            return this.body((byte[])object);
        }
        this.core.body(object, mapperType);
        return this;
    }

    public RequestSpecification body(String body) {
        this.core.body(body);
        return this;
    }

    public RequestSpecification body(byte[] body) {
        this.core.body(body);
        return this;
    }

    public RequestSpecification body(File body) {
        this.core.body(body);
        return this;
    }

    public RequestSpecification body(InputStream body) {
        this.core.body(body);
        return this;
    }

    public RequestSpecification contentType(ContentType contentType) {
        Preconditions.checkNotNull((Object)contentType, ContentType.class);
        return this.header(HeaderNames.CONTENT_TYPE.asString(), contentType, new Object[0]);
    }

    public RequestSpecification contentType(String contentType) {
        Preconditions.checkNotNull((Object)contentType, (Object)"Content-Type header cannot be null");
        return this.header(HeaderNames.CONTENT_TYPE.asString(), contentType, new Object[0]);
    }
}

