/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.matchers.statematchers;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.pages.WebElementState;

public class MissingWebElement
implements WebElementState {
    private final String elementName;
    private String expectedErrorMessage;

    public MissingWebElement(String elementName) {
        this.elementName = elementName;
    }

    public boolean isVisible() {
        return false;
    }

    public boolean isCurrentlyVisible() {
        return false;
    }

    public boolean isCurrentlyEnabled() {
        return false;
    }

    public void shouldBeVisible() {
        this.failWithMessage("Element should be visible");
    }

    public void shouldBeCurrentlyVisible() {
        this.failWithMessage("Element should be visible");
    }

    public void shouldNotBeVisible() {
    }

    public void shouldNotBeCurrentlyVisible() {
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean containsText(String value) {
        return false;
    }

    public boolean containsValue(String value) {
        return false;
    }

    public boolean containsOnlyText(String value) {
        return false;
    }

    public boolean containsSelectOption(String value) {
        return false;
    }

    public void shouldContainText(String textValue) {
        String errorMessage = String.format("The text '%s' was not found in the web element. Element text '%s'.", textValue, this.elementName);
        this.failWithMessage(errorMessage);
    }

    public void shouldContainOnlyText(String textValue) {
        String errorMessage = String.format("The text '%s' does not match the elements text '%s'.", textValue, this.elementName);
    }

    public void shouldContainSelectedOption(String textValue) {
        this.failWithMessage(String.format("The list element '%s' was not found in the web element %s", textValue, this.elementName));
    }

    public void shouldNotContainText(String textValue) {
    }

    public void shouldBeEnabled() {
        this.failWithMessage(String.format("Field '%s' should be enabled", this.elementName));
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isDisabled() {
        return false;
    }

    public void shouldNotBeEnabled() {
    }

    public String getSelectedVisibleTextValue() {
        return null;
    }

    public String getSelectedValue() {
        return null;
    }

    public List<String> getSelectOptions() {
        return null;
    }

    public boolean isPresent() {
        return false;
    }

    public void shouldBePresent() {
        this.failWithMessage(String.format("Field '%s' should be present", this.elementName));
    }

    public void shouldNotBePresent() {
    }

    public boolean isSelected() {
        return false;
    }

    public String getTextValue() {
        return null;
    }

    public String getValue() {
        return "";
    }

    public String getText() {
        return "";
    }

    public String getAttribute(String name) {
        return "";
    }

    public WebElementState expect(String errorMessage) {
        this.expectedErrorMessage = errorMessage;
        return this;
    }

    public boolean isClickable() {
        return false;
    }

    private void failWithMessage(String errorMessage) {
        throw new AssertionError((Object)this.getErrorMessage(errorMessage));
    }

    protected String getErrorMessage(String defaultErrorMessage) {
        return Optional.ofNullable(this.expectedErrorMessage).orElse(defaultErrorMessage);
    }
}

